/*
 * lat_ctx.c - context switch timer 
 *
 * usage: lat_ctx [-s size] #procs [#procs....]
 *
 * Copyright (c) 1994 Larry McVoy.  Distributed under the FSF GPL with
 * additional restriction that results may published only if
 * (1) the benchmark is unmodified, and
 * (2) the version in the sccsid below is included in the report.
 * Support for this development by Sun Microsystems is gratefully acknowledged.
 */
char	*id = "$Id: lat_ctx.c,v 1.3 1995/10/26 04:03:09 lm Exp lm $\n";

#include "timing.h"
#include "bench.h"
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <fcntl.h>

#define	CTX_TRIES	1
#define	MAXPIPE	100

int	process_size;
char	*data;
int	pids[MAXPIPE];
double	r[CTX_TRIES];
double	pipe_cost(int *, int);
int	sumit();
double	ctx(double overhead, int procs, int *hint);
double	_pipe_cost(int *, int);
void	doit(), killem();

int
main(ac, av)
	int	ac;
	char	**av;
{
	int	i;
	int	tries;
	double	overhead;
	int	hint1 = 0, hint2 = 0;
	double	min = 1E+200;
	double	result;

	process_size = 64<<10;
	data = malloc(process_size);
	bzero(data, process_size);
	overhead = pipe_cost(&hint1, 16);
	printf("%.0f ( ", overhead);
	for (i = 0; i < CTX_TRIES; ++i) {
		printf("%.0f ", r[i]);
	}
	printf(")\n");
}


/*
 * Run the overhead test several times, taking the smallest overhead to
 * be valid.  The reasoning is that larger overheads probably included
 * the cost of some other system activity.
 *
 * The cost returned is the cost of going through one pipe once in usecs.
 *
 * XXX - this varies too much.
 */
double
pipe_cost(int *hint, int p)
{
	int	i;
	double	min = 1E+200;

	for (i = 0; i < CTX_TRIES; ++i) {
		r[i] = -1;
	}
	for (i = 0; i < CTX_TRIES; ++i) {
		double	j = _pipe_cost(hint, 16);

		if (min > j) {
			min = j;
		}
		insertsort(r, CTX_TRIES, j);
	}
	return (min);
}

/*
 * Calculate the cost of passing a byte through a pipe.  I do it with a
 * bunch of pipes to try and burn through the onboard caches.  Note that
 * on a Sun SPARC ss2, it made little difference if the loop was over one
 * or thirty pipes.
 */
double
_pipe_cost(int *hint, int procs)
{
	int	p[MAXPIPE][2];
	int	msg = 0, sum, i, k = 0, n, N;
	uint64	usecs;

	/*
	 * Get a bunch of pipes.
	 */
	n = 0;
	while (n < procs && pipe(p[n]) != -1)
		n++;

	/*
	 * Measure the overhead of passing a byte around the ring.
	 */
	if (write(p[k = 0][1], &msg, sizeof(msg)) != sizeof(msg)) {
		perror("read/write on pipe");
		exit(1);
	}
	if (0 || *hint) {
		N = *hint;
		goto timit;
	}
	LOOP_FIRST(N, usecs, ENOUGH)
	if (read(p[k][0], &msg, sizeof(msg)) != sizeof(msg)) {
		perror("read/write on pipe");
		exit(1);
	}
	if (++k == n) {
		k = 0;
	}
	sum = sumit();
	if (write(p[k][1], &msg, sizeof(msg)) != sizeof(msg)) {
		perror("read/write on pipe");
		exit(1);
	}
	LOOP_LAST(N, usecs, ENOUGH);
	*hint = N;

	for (i = 0; i < n; ++i) {
		close(p[i][0]);
		close(p[i][1]);
	}
	use_result(sum);
	return ((double)usecs / N);
}

int
sumit()
{
	int	i, sum = 0;
	int	*d = (int*)data;

#define	TEN	sum+=d[0]+d[1]+d[2]+d[3]+d[4]+d[5]+d[6]+d[7]+d[8]+d[9];d+=10;
#define	FIFTY	TEN TEN TEN TEN TEN
#define	HUNDRED	FIFTY FIFTY
#define	HALFK	HUNDRED HUNDRED HUNDRED HUNDRED HUNDRED TEN sum+=*d++;sum+=*d++;

	for (i = process_size/sizeof(int); i > 512; i -= 512) {
		HALFK
	}
	return (sum);
}

#define	SIZE	1<<20
caches()
{
        int     i, sum = 0;
        char    *d = (char *)malloc(SIZE);
        char    *save = d;

        bzero(d, SIZE);

#define TEN     sum+=d[0]+d[1]+d[2]+d[3]+d[4]+d[5]+d[6]+d[7]+d[8]+d[9];d+=10;
#define FIFTY   TEN TEN TEN TEN TEN
#define HUNDRED FIFTY FIFTY
#define HALFK   HUNDRED HUNDRED HUNDRED HUNDRED HUNDRED TEN sum+=*d++;sum+=*d++;
#define KILO    HALFK HALFK

        for (i = SIZE; i > 8192; i -= 8192) {
                KILO KILO KILO KILO
                KILO KILO KILO KILO
        }
        free(save);
        return (sum);
}

