/*
 * lat_ctx.c - context switch timer 
 *
 * usage: lat_ctx [-s size] #procs [#procs....]
 *
 * Copyright (c) 1994 Larry McVoy.  Distributed under the FSF GPL with
 * additional restriction that results may published only if
 * (1) the benchmark is unmodified, and
 * (2) the version in the sccsid below is included in the report.
 * Support for this development by Sun Microsystems is gratefully acknowledged.
 */
char	*id = "$Id: lat_ctx.c,v 1.3 1995/10/26 04:03:09 lm Exp lm $\n";

#include "timing.h"
/*
 * You may not report numbers with this define turned on.
 */
/*#define	VIRTUAL_ADDR_CACHE	/*Sun internal only*/

#define	CTX_TRIES	1

int	process_size, *data;	/* size & pointer to an array that big */
int	pids[100];
int	pipe_cost(), overhead(), ctx(), sumit();
void	doit();
double	r[CTX_TRIES];

int
main(ac, av)
	int	ac;
	char	**av;
{
	int	i;
	int	tries;
	int	result;
	int	min;
	int	overhead;
	int	writes;

	process_size = 64<<10;
	data = (int *)malloc(process_size);
	overhead = pipe_cost();
	printf("%d ( ", overhead);
	for (i = 0; i < CTX_TRIES; ++i) {
		printf("%.0f ", r[i]);
	}
	printf(")\n");
	return (0);
}

/*
 * Run the overhead test several times, taking the smallest overhead to
 * be valid.  The reasoning is that larger overheads probably included
 * the cost of some other system activity.
 *
 * The cost returned is the cost of going through one pipe once in usecs.
 *
 * XXX - this varies too much.
 */
int
pipe_cost()
{
	int	i, min = 0x7fffffff;

	for (i = 0; i < CTX_TRIES; ++i) {
		r[i] = -1;
	}
	for (i = 0; i < CTX_TRIES; ++i) {
		int	j = overhead();
		extern	insertsort(double *, int, double);

		if (min > j) {
			min = j;
		}
		insertsort(r, CTX_TRIES, (double)j);

		/*
		 * This seems to disturb the caches just
		 * enough that I get consistent overhead numbers.
		 * Weird, I know.
		 */
	}
	return (min);
}

/*
 * Calculate the cost of passing a byte through a pipe.  I do it with a
 * bunch of pipes to try and burn through the onboard caches.  Note that
 * on a Sun SPARC ss2, it made little difference if the loop was over one
 * or thirty pipes.
 */
int
overhead()
{
	int	p[100][2];
	int	msg = 0, sum, i, n, k;
	int	writes;

	/*
	 * Get a bunch of pipes.
	 */
	n = 0;
	while (n < 20 && pipe(p[n]) != -1)
		n++;

	/*
	 * Measure the overhead of passing a byte around the ring.
	 */
	if (write(p[k = 0][1], &msg, sizeof(msg)) != sizeof(msg)) {
		perror("read/write on pipe");
		exit(1);
	}
	writes = 200; 
	do {
		writes <<= 2;
		k = 0;
		start(0);
		for (i = 0; i < writes; ++i) {
			if (read(p[k][0], &msg, sizeof(msg)) != sizeof(msg)) {
				perror("read/write on pipe");
				exit(1);
			}
			if (++k == n) {
				k = 0;
			}
			sum = sumit();
			if (write(p[k][1], &msg, sizeof(msg)) != sizeof(msg)) {
				perror("read/write on pipe");
				exit(1);
			}
		}
		k = stop(0,0);
	} while (k <= 1000000);

	for (i = 0; i < n; ++i) {
		close(p[i][0]);
		close(p[i][1]);
	}
	return (k / writes);
}

int
sumit()
{
	int	i, sum = 0;
	int	*d = data;

#define	TEN	sum+=d[0]+d[1]+d[2]+d[3]+d[4]+d[5]+d[6]+d[7]+d[8]+d[9];d+=10;
#define	FIFTY	TEN TEN TEN TEN TEN
#define	HUNDRED	FIFTY FIFTY
#define	HALFK	HUNDRED HUNDRED HUNDRED HUNDRED HUNDRED TEN sum+=*d++;sum+=*d++;

	for (i = process_size/sizeof(int); i > 512; i -= 512) {
		HALFK
	}
	return (sum);
}

#define	SIZE	(1024 * 1024)

/*
 * This is a huge unrolled loop that is supposed to blow the instruction
 * and the data caches in an attempt to get more reproducible numbers.
 * It sort of works.
 */
int
caches()
{
	int	i, sum = 0;
	char	*d = (char *)malloc(SIZE);
	char	*save = d;

	bzero(d, SIZE);

#define	TEN	sum+=d[0]+d[1]+d[2]+d[3]+d[4]+d[5]+d[6]+d[7]+d[8]+d[9];d+=10;
#define	FIFTY	TEN TEN TEN TEN TEN
#define	HUNDRED	FIFTY FIFTY
#define	HALFK	HUNDRED HUNDRED HUNDRED HUNDRED HUNDRED TEN sum+=*d++;sum+=*d++;
#define	KILO	HALFK HALFK

	for (i = SIZE; i > 8192; i -= 8192) {
		KILO KILO KILO KILO
		KILO KILO KILO KILO
	}
	free(save);
	return (sum);
}
