#! /bin/awk -f
# convert from *-tab.h to csv

BEGIN {
	FS = ", *"

	num = 2

	nest = 1
}

/^\/\*.*\*\// {
	printf "%d,\"%s\"\n", num, $0
	num++

	next
}

/^};$/ {
	exit
}

/^\t*{$/ {
	if( nest == 1 ){
		printf "%d", num
	}
	printf ",\"{\""
	printf ",\\n"

	nest++

	next
}

/^\t*},$/ {
	nest--

	printf ",\"}\""
	printf ",\"\\n\""
	if( nest == 1 ){
		printf "\n"
		num++
	}

	next
}

/^\t*.*$/ {
	gsub( /^[ \t]+/, "", $1 )

	for( i = 1; i <= NF; i++ ){
		gsub( /\"/, "\"\"", $i )

		if( $i ~ /^$/ ){
			#
		} else if( $i ~ /^[0-9].*$/ ){
			printf ",%d", $i
		} else {
			printf ",\"%s\"", $i
		}

		if( i == NF ){
			printf ",\"\\n\""
		}
	}

	next
}
