/*
    File:       Resource.h

    Function:	Read mac resource forks under unix

    Author:     Andrew Willmott

    Copyright:  (c) 1999, Andrew Willmott
*/

#ifndef __Resource__
#define __Resource__

#include <stdio.h>
#include "Types.h"

typedef Char            ResID[5];
typedef const Char      *ResIDParam;
typedef signed short    ResShort;
typedef unsigned int    ResLong;

struct ResHeader
{
	ResLong    dataOffset;
	ResLong    mapOffset;
	ResLong    dataLength;
	ResLong    mapLength;
};

struct ResMap
{
	ResShort 	resAttr;
	ResShort	typeOffset;
	ResShort	nameOffset;
	ResShort	numTypes;
};

struct ResType
{
	ResID       id;
	ResShort    items;
	ResShort    offset;
};

struct Resource
{
	ResShort    id;
	ResShort    nameOffset;
	Char        attr;
	ResLong     dataOffset;
	Char        *name;
};

typedef Resource *ResPtr;

class ResourceFile
{
public:

	Void        Open(const Char *filename);
	Void        Close();
	            
	Void		PrintAllResources();
	Void		PrintResources(Int i);

	Int			GetNumTypes();
	Int			GetNumResources(Int i);

	Void        *GetResource(ResIDParam typeID, ResShort resID, ResLong *size = 0);
	const Char  *GetResourceName(ResIDParam typeID, ResShort resID);

	Int 		GetResourceNumber(Int i, ResShort resID);
	Int 		GetTypeNumber(ResIDParam typeID);

// internal
	Void        ReadMap();
	Void        *ReadResource(ResLong *size = 0);
	Void        *ReadResource(Int i, Int j, ResLong *size = 0);
	            
	Void        ReadID(ResID id);
	ResLong     ReadLong();
	ResShort    ReadShort();
	            
	FILE        *resFork;
	ResHeader   resHeader;
	ResMap      resMap;
	ResType     *resTypes;
	ResPtr      *resLists;
};

#endif
