/* Copyleft@2004,2005 - pancake@phreaker.net */

#include "main.h"
#include <stdio.h>
#if __linux__ || __FreeBSD__
#include <sys/statvfs.h>
#else
#include <sys/param.h>
#include <sys/mount.h>
#endif

#if HAVE_GMP
void
disk_get_value(char *name, mpz_t *used)
{
	mpz_t tmp;
#else
unsigned long
disk_get_value(char *name)
{
	unsigned long used=0;
#endif
	int ret;

#if __linux__ || __FreeBSD__ || __NetBSD__
	struct statvfs sv;
	ret=statvfs(name,&sv);
#else
	struct statfs sv;
	ret=statfs(name,&sv);
#endif

#if HAVE_GMP
	mpz_init(*used);
	mpz_init(tmp);
#endif

	if (ret)
	{
		printf("Invalid disk '%s'\n",name);
		exit(1);
	}

#if HAVE_GMP
	mpz_set_d(tmp,sv.f_blocks-sv.f_bavail);
	mpz_mul_ui(*used,tmp,2);
#else
	used=(sv.f_blocks-sv.f_bavail)*2;
	used*=1024;

	return used;
#endif
}
