/* Copleft@2004,2005 - pancake@phreaker.net */

#include "main.h"
#include <sys/stat.h>

#if HAVE_GMP
void file_get_value(char *file, mpz_t *size)
#else
unsigned long file_get_value(char *file)
#endif
{
	struct stat sb;
	int ret;

	ret=stat(file,&sb);
	if (ret)
	{
		printf("Cannot stat file '%s'.\n",file);
		exit(1);
	}

#if HAVE_GMP
	mpz_set_d(*size,sb.st_size);
#else
	return sb.st_size;
#endif
}
