/*
 *  MICO --- a free CORBA implementation
 *  Copyright (C) 1997 Kay Roemer & Arno Puder
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Send comments and/or bug reports to:
 *                 mico@informatik.uni-frankfurt.de
 */

import Node;

public class RelationNode extends Node {

	public RelationNode( String aName )
	{
	    name = aName;
	}

	private String quote (String s)
	{
	    if (s.length() == 0)
		return "''";
	    if (s.indexOf (' ') < 0)
		return s;
	    return "'" + s + "'";
	}

	public void print( StringBuffer ostr )
	{
	    ostr.append( "(" + quote (name) + ")" );
	}

	public boolean equals (Object o)
	{
            return (o != null && (o instanceof RelationNode));
        }
}




