#include <stdio.h>
#include <string.h>
#include "minami.h"
#include "item.h"

static ItemTab itemtab[] = {
	{0, "", "", 0, 0},
	{1, "ϥ", "Hawaiian shirt", 0, -1,},
	{2, "ǡ󤯤夰", "daemon robe", 0, 10000,},
	{3, "֥˥󥰥ɥ쥹", "evening dress", 0, 10000,},
	{4, "ԡ", "one-piece dress", 0, 10000,},
	{5, "6󥳥ץ", "costume", 0, 10000,},
	{6, "", "work cloth", 0, -1,},
	{7, "ϥť", "wig", 0, 300,},
	{8, "ɤ", "lingerie", 0, 10000,},
	{9, "", "seuce", 0, -1,},
	{10, "ȥ󥫥", "fried pork cutlet", 0, -1,},
	{11, "ˡΥ", "magic seuce", 0, -1,},
	{12, "SPAMδ̵", "tin of spam", 0, 300,},
	{13, "Ǥδ̵", "tin of oden", 0, 300,},
	{14, "ץδ̵", "tin of pudding", 0, 300,},
	{15, "Ĺ", "long sword", 0, -1,},
	{16, "С", "Excalibur", 0, -1,},
	{17, "BSD magazine", "book", 0, -1,},
	{18, "إ٥", "bell", 0, -1,},
	{19, "ؿ", "candelabrum", 0, -1,},
	{20, "å", "ticket", 0, -1,},
	{21, "ǡ󤯤Υե", "daemon fork", 0, -1,},
	{22, "ڥ󥮥ʪ", "statue of penguin", 0, -1,},
	{23, "ǡ󤯤οͷ", "figurine of daemon", 0, -1,},
	{24, "ʡ", "fukubiki ticket", 0, -1,},
	{25, "ID", "ID card", 0, -1,},
	{26, "", "water", 0, -1,},
	{27, "֤", "red potion", 0, 100000,},
	{28, "﫤ξ", "brass wand", 0, 100000,},
	{29, "ͳѷ", "amulet of square", 0, 100000,},
	{30, "", "light", 0, -1,},
	{31, "ǽ", "skeleton key", 0, -1,},
	{32, "ƥåڡѡ", "tissue paper", 0, -1,},
	{33, "ѥ", "compass", 0, -1,},
	{34, "Ͽ", "map", 0, -1,},
	{35, "", "stone", 0, -1,},
	{36, "ϥ磻ιԷ", "travel ticket for hawaii", 0, -1,},
	{37, "Ұ", "staff ID card", 0, -1,},
	{38, "", "camera", 0, 1000,},
	{39, "ñ˻", "MMB", 0, 10000,},
	{40, "", "paper", 0, -1,},
	{41, "CDROM", "cdrom", 0, -1,},
	{42, "ӡᥤ", "ruby mace", 0, 10000,},
	{43, "ޥå", "match box", 0, -1,},
	{44, "ʹ", "news paper", 0, -1,},
	{45, "ѥեå", "pamphlet", 0, -1,},
	{46, "", "candle", 0, -1,},
	{0},
};

ItemTab *
ItemByNum(int n)
{
    return &itemtab[n];
}

ItemTab *
ItemByName(const char *name)
{
    int i;
    ItemTab *itab;

    for(i=1 ; i<NUM_ITEMS; ++i){
	itab = ItemByNum(i);
	if(!itab->name)
	    return NULL;

	if(EQ(itab->ename, name))
	    return itab;
    }
    return NULL;
}
