#include <stdio.h>
#include <stdlib.h>
#ifdef M_HAVE_CURSES_H
#include <curses.h>
#endif
#ifdef M_HAVE_TERM_H
#include <term.h>
#endif
#ifdef M_HAVE_TERMCAP_H
#include <termcap.h>
#endif
#include <sys/ioctl.h>
#include <sys/termios.h>
#include <fcntl.h>
#include <string.h>
#include <sys/types.h>
#include <sys/time.h>
#include <unistd.h>

#include "minami.h"

static struct termios tbuf_save;
static char buf[BUFSIZ];
static char *cl;
static char *me;
static char *mr;
static char *vb;
static char *cr;
static char *bs;
static char *dl;

char *term_me;
char *term_mr;

void
term_init()
{
    char b[BUFSIZ];
    char *name;
    char *area = buf;

    name = getenv("TERM");
    if(tgetent(b, name) <= 0)
	tgetent(b, "vt100");

    cl = tgetstr("cl", &area);
    mr = tgetstr("us", &area);
    me = tgetstr("me", &area);
    vb = tgetstr("vb", &area);
    cr = tgetstr("cr", &area);
    bs = tgetstr("le", &area);
    dl = tgetstr("dl", &area);

    if(!cl)
	cl = "";
    if(!mr)
	mr = "";
    if(!me)
	me = "";
    if(!vb)
	vb = "";
    if(!cr)
	cr = "";
    if(!dl)
	dl = "";

    tcgetattr(0, &tbuf_save);

    term_mr = mr;
    term_me = me;
}

void
term_setraw(int vmin, int vtime)
{
    struct termios tbuf;

    memcpy(&tbuf, &tbuf_save, sizeof(tbuf));

    tbuf.c_lflag &= ~ECHO;
    tbuf.c_lflag &= ~ICANON;
    tbuf.c_cc[VMIN] = vmin;
    tbuf.c_cc[VTIME] = vtime;
    tcsetattr(0, TCSAFLUSH, &tbuf);
}

void
term_unsetraw()
{
    tcsetattr(0, TCSAFLUSH, &tbuf_save);
}

int
More()
{
    int c;
    fd_set r, w, e;
    struct timeval t;
    int ret;
    int i = 0;

    if(you.f_debug && you.f_nowait)
	return ' ';

    fflush(stdout);
    fmtmsg("\n--more---");
    term_setraw(1, 0);
    while(1){
	FD_ZERO(&r);
	FD_ZERO(&w);
	FD_ZERO(&e);
	FD_SET(0, &r);
	t.tv_sec = 0;
	t.tv_usec = 300000;
	ret = select(1, &r, &w, &e, &t);
	if(ret == 0){
	    if(bs){
		fprintf(stdout, "%s%c", bs, "/-\\|/-\\|"[(i++)%8]);
	    }
	    fflush(stdout);
	}
	else{
	    c = fgetc(stdin);
	    if(c)
		break;
	}
    }
    term_unsetraw();
    fmtmsg("%s", dl);
    fmtmsg("%s \n", bs);

    return c;
}

int
Getc()
{
    int c;

    term_setraw(1, 0);
    c = fgetc(stdin);
    term_unsetraw();

    return c;
}

void
InitTerm()
{
    term_init();
}

