/*   This has nothing to do with cryptography. */
#ifndef __MAD_H
#define __MAD_H

#ifdef HAVE_MAD
#   define INLINE 
#else
#   ifndef INLINE
#       define INLINE inline
#   endif
#endif

#ifdef HAVE_MAD

/* The Memory Allocation Debugging system */

/* GNU headers define this as macros */
#ifdef malloc
#   undef malloc
#endif

#ifdef calloc
#   undef calloc
#endif

#define malloc(x)	mad_alloc (x, __FILE__, __LINE__)
#define calloc(x, y)	mad_alloc (x * y, __FILE__, __LINE__)
#define realloc(x, y)	mad_realloc (x, y, __FILE__, __LINE__)
#define xmalloc(x, y)	mad_alloc (x, __FILE__, __LINE__)
#define strdup(x)	mad_strdup (x, __FILE__, __LINE__)
#define tempnam(x, y)	mad_tempnam (x, y, __FILE__, __LINE__)
#define free(x)		mad_free (x, __FILE__, __LINE__)

void mad_check (char *file, int line);
void *mad_alloc (int size, char *file, int line);
void *mad_realloc (void *ptr, int newsize, char *file, int line);
char *mad_strdup (const char *s, char *file, int line);
char *mad_tempnam (const char *s, const char *y, char *file, int line);
void mad_free (void *ptr, char *file, int line);
void mad_finalize (char *file, int line);

#if 0

#define open(a,b...) mad_open (__FILE__, __LINE__, a, b)
#define creat(a,b) mad_creat (__FILE__, __LINE__, a, b)
#define socket(a,b,c) mad_socket (a,b,c,__FILE__,__LINE__)
#define accept(a,b,c) mad_accept (a,b,c,__FILE__,__LINE__)

#ifndef _MAD_C
int mad_open (char *file, int line, char *p, int f,...);
#endif
int mad_creat (char *file, int line, char *p, int m);
int mad_socket (int domain, int type, int protocol, char *file, int line);
int mad_accept (int sockfd, void *addr, int *addrlen, char *file, int line);

#endif

#else

#define mad_finalize(x, y)
#define mad_check(file,line)

#endif /* HAVE_MAD */

#endif /* __MAD_H */
