/* ttio.h

   Default definitions for terminal I/O macros... */

/*
 * Copyright (c) 1995 RadioMail Corporation.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of RadioMail Corporation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY RADIOMAIL CORPORATION AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
 * RADIOMAIL CORPORATION OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software was written for RadioMail Corporation by Ted Lemon
 * under a contract with Vixie Enterprises, and is based on an earlier
 * design by Paul Vixie.
 */

/* System-dependent defines... */

#ifndef NO_TERMIOS
#include <termios.h>
#endif

#ifndef CVT_TTYNAME
#define CVT_TTYNAME(buf, name) sprintf (buf, "/dev/%s", name)
#endif

#ifndef TTY_STATE
#define TTY_STATE	struct termios
#endif

#ifndef TTY_OPEN_FLAGS
#define TTY_OPEN_FLAGS	(O_RDWR | O_NDELAY)
#endif

#ifndef TTY_OPEN_MODE
#define TTY_OPEN_MODE	(0600)
#endif

#ifndef INIT_TTY_STATE
#define INIT_TTY_STATE(ts)				\
  ((ts.c_iflag = IGNBRK | IGNPAR),			\
   (ts.c_oflag = 0),					\
   (ts.c_cflag = CS8 | CREAD | CLOCAL),			\
   (ts.c_lflag = NOKERNINFO | PENDIN),			\
   (ts.c_cc [VMIN] = 1),				\
   (ts.c_cc [VTIME] = 2),				\
   (ts.c_ispeed = B57600),				\
   (ts.c_ospeed = B57600))
#endif

#ifndef NORMAL_TTY
#define NORMAL_TTY(ts)					\
  ((ts.c_iflag |= ICRNL | IMAXBEL | BRKINT),		\
   (ts.c_oflag |= OPOST | ONLCR),			\
   (ts.c_cflag = (ts.c_cflag & ~CLOCAL) | HUPCL),	\
   (ts.c_lflag |= (ICANON | ISIG | IEXTEN | ECHO | 	\
		    ECHOE | ECHOKE | ECHOCTL | PENDIN)),\
   (ts.c_cc [VEOF] = 4),	/* Control D */		\
   (ts.c_cc [VEOL] = _POSIX_VDISABLE),			\
   (ts.c_cc [VEOL2] = _POSIX_VDISABLE),			\
   (ts.c_cc [VERASE] = 127),	/* Delete */		\
   (ts.c_cc [VWERASE] = 23),	/* Control W */		\
   (ts.c_cc [VKILL] = 21),	/* Control U */		\
   (ts.c_cc [VREPRINT] = 18),	/* Control R */		\
   (ts.c_cc [VINTR] = 3),	/* Control C */		\
   (ts.c_cc [VQUIT] = 28),	/* Control \ */		\
   (ts.c_cc [VSUSP] = 26),	/* Control Z */		\
   (ts.c_cc [VDSUSP] = 6),	/* Control F */		\
   (ts.c_cc [VSTART] = 17),	/* Control Q */		\
   (ts.c_cc [VSTOP] = 19),	/* Control S */		\
   (ts.c_cc [VLNEXT] = 22),	/* Control V */		\
   (ts.c_cc [VDISCARD] = _POSIX_VDISABLE),		\
   (ts.c_cc [VSTATUS] = 20))	/* Control T */
#endif

#ifndef HUPCL_TTY
#define HUPCL_TTY(ts) \
  (ts.c_cflag = (ts.c_cflag & ~CLOCAL) | HUPCL)
#endif

#ifndef SET_BITS
#define SET_BITS(ts, bpw)				\
   (ts.c_cflag = ((ts.c_cflag & ~CSIZE) |		\
		     ((bpw) == 5 ? CS5 :		\
		      ((bpw) == 6 ? CS6 :		\
		       ((bpw) == 7 ? CS7 :		\
			((bpw) == 8 ? CS8 :		\
			 (warn ("%d bits per word not supported - using 8.", \
				(bpw)), CS8)))))))
#endif

#ifndef SET_PARITY
#define SET_PARITY(ts, pval)						\
  (ts.c_cflag =								\
   (ts.c_cflag & ~(PARENB | PARODD))					\
   | (pval == PARITY_NONE ? 0 :						\
      (pval == PARITY_EVEN ? PARENB :					\
       (pval == PARITY_ODD ? PARENB | PARODD :				\
	(pval == PARITY_MARK ?						\
	 (warn ("Mark parity not supported - using none."), 0) :	\
	 (pval == PARITY_SPACE ?					\
	  (warn ("Space parity not supported - using none."), 0) :	\
	  (error ("Bad parity encountered in SET_PARITY - BUG!"))))))))
#endif

#ifndef SET_NO_FLOW_CTL
#define SET_NO_FLOW_CTL(ts)						\
  ((ts.c_iflag &= ~(IXON | IXOFF)),					\
   (ts.c_cflag &= ~(CCTS_OFLOW | CRTS_IFLOW)))
#endif

#ifndef SET_HW_FLOW_CTL
#define SET_HW_FLOW_CTL(ts)						\
  (ts.c_cflag |= CCTS_OFLOW | CRTS_IFLOW)
#endif

#ifndef SET_XON_XOF_FLOW_CTL
#define SET_XON_XOFF_FLOW_CTL(ts)					\
  (ts.c_iflag |= (IXON | IXOFF))
#endif

#ifndef SET_TX_SPEED
#define SET_TX_SPEED(ts, speed)						\
  (ts.c_ospeed = (speed))
#endif

#ifndef SET_RX_SPEED
#define SET_RX_SPEED(ts, speed)						\
  (ts.c_ispeed = (speed))
#endif

#ifndef PUT_TTY_STATE
#define PUT_TTY_STATE(fd, ts)						\
  (tcsetattr (fd, TCSADRAIN, &ts) >= 0)
#endif

#ifndef GET_TTY_STATE
#define GET_TTY_STATE(fd, ts)						\
  (tcgetattr (fd, &ts) >= 0)
#endif

#ifndef SET_DTR
#define SET_DTR(fd)							\
  ioctl (fd, TIOCSDTR, 0)
#endif

#ifndef RESET_DTR
#define RESET_DTR(fd)							\
  ioctl (fd, TIOCCDTR, 0)
#endif

#ifndef TTY_DRAIN
#define TTY_DRAIN(fd)							\
  tcdrain (fd)
#endif

#ifndef SET_CTTY
#define SET_CTTY(fd)							\
  { 									\
    int val = 1;							\
    if (ioctl (fd, TIOCSCTTY, &val) < 0)				\
      error ("Can't set controlling terminal: %m");			\
  }
#endif

/* This is the delay required between command characters sent to the
   modem.  It should be about 0.15 seconds, but there's no standard
   way to make such a delay, so unless osdep.h defines one (and it
   should), we have to wait up to two seconds.  (Sleep doesn't guarantee
   that you'll get a whole second of delay if you only sleep for one
   second.) */
#ifndef USDELAY
#define USDELAY() sleep(2)
#endif

#ifndef DELAY_ONE_SECOND
#define DELAY_ONE_SECOND() sleep(2)
#endif

#ifndef _PATH_TTYLOCK
#define _PATH_TTYLOCK "/var/spool/uucp/LCK..%s"
#endif

/* modemd-specific definitions... */
#define PARITY_NONE	0
#define PARITY_EVEN	1
#define PARITY_ODD	2
#define PARITY_MARK	3
#define PARITY_SPACE	4

