#!/usr/bin/perl

$SPAMC = "/usr/bin/spamc -c";

$LIMIT_OVERRIDE = -1;
# $LIMIT_OVERRIDE = 2.5;

if (@ARGV != 1) {
    print "Usage: external_filter.pl <filename>\n";
    exit;
}

$filename = shift(@ARGV);

# get the real request body
$request_body = "";
open(FILE, $filename) || die("Could not open $filename");
while(<FILE>) {
    $request_body .= $_;
}
close(FILE);

$output = "";
@pairs= split(/&/, $request_body);
foreach $pair (@pairs) {
    ($name, $value) = split(/=/, $pair); 
    $name =~ tr/+/ /;
    $name =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    $value =~ tr/+/ /;
    $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    $output .= "$name: $value\n\n";
}

open(FILE, ">/tmp/xyz");
print(FILE $output);
close(FILE);

pipe(FROM_PERL, TO_PROGRAM);
pipe(FROM_PROGRAM, TO_PERL);

$pid = fork();
die "Couldn't fork: $!" unless defined $pid;

if ($pid == 0)  {
    # child

    close(STDIN);
    open(STDIN, '<&FROM_PERL') || die ("Error: $!");

    close(STDOUT);
    open(STDOUT, '>&TO_PERL') || die ("Error: $!");

    close(STDERR);
    open(STDERR, '>&STDOUT') || die;

    close(FROM_PROGRAM);
    close(TO_PROGRAM);

    exec $SPAMC;
    die;
}

# parent
close FROM_PERL;
close TO_PERL;

# send data to the program
print TO_PROGRAM $output;
close(TO_PROGRAM);

# get the program output back
$verdict = "";
while (<FROM_PROGRAM>)  {
    $verdict .= $_;
}
chomp($verdict);

($score, $threshold) = split(/\//, $verdict); 
if ($LIMIT_OVERRIDE != -1) {
    $threshold = $LIMIT_OVERRIDE;
}

if ($score > $threshold) {
    $rc = 1;
} else {
    $rc = 0;
}

print "$rc OK ($score/$threshold)\n";
