/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.figures;

import java.awt.event.MouseEvent;
import org.jhotdraw.figures.TextTool;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.DeleteCommand;
import org.jhotdraw.standard.FigureTransferCommand;
import org.jhotdraw.standard.TextHolder;
import org.jhotdraw.util.Undoable;

public class ConnectedTextTool
extends TextTool {
    private Figure myConnectedFigure;

    public ConnectedTextTool(DrawingEditor drawingEditor, Figure figure) {
        super(drawingEditor, figure);
    }

    public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
        super.mouseDown(mouseEvent, n, n2);
        if (this.getTypingTarget() != null) {
            TextHolder textHolder = this.getTypingTarget();
            this.setConnectedFigure(this.drawing().findFigureInsideWithout(n, n2, textHolder.getRepresentingFigure()));
            if (this.getConnectedFigure() != null && textHolder != null && this.getConnectedFigure().getTextHolder() != textHolder) {
                textHolder.connect(this.getConnectedFigure().getDecoratedFigure());
                this.getConnectedFigure().addDependendFigure(this.getAddedFigure());
            }
        }
    }

    protected void endEdit() {
        super.endEdit();
        if (this.getUndoActivity() != null && this.getUndoActivity() instanceof UndoActivity) {
            ((UndoActivity)this.getUndoActivity()).setConnectedFigure(this.getConnectedFigure());
        } else if (this.getConnectedFigure() != null && this.isDeleteTextFigure()) {
            this.getConnectedFigure().removeDependendFigure(this.getAddedFigure());
        }
    }

    protected void setConnectedFigure(Figure figure) {
        this.myConnectedFigure = figure;
    }

    public Figure getConnectedFigure() {
        return this.myConnectedFigure;
    }

    public void activate() {
        super.activate();
        this.setConnectedFigure(null);
    }

    protected Undoable createDeleteUndoActivity() {
        DeleteCommand deleteCommand = new DeleteCommand("Delete", this.editor());
        return new DeleteUndoActivity(deleteCommand, this.getConnectedFigure());
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this.view(), this.getTypingTarget().getText());
    }

    public static class DeleteUndoActivity
    extends DeleteCommand.UndoActivity {
        private Figure myConnectedFigure;

        public DeleteUndoActivity(FigureTransferCommand figureTransferCommand, Figure figure) {
            super(figureTransferCommand);
            this.setConnectedFigure(figure);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            FigureEnumeration figureEnumeration = this.getAffectedFigures();
            while (figureEnumeration.hasNextFigure()) {
                Figure figure = figureEnumeration.nextFigure();
                if (figure.getTextHolder() == null) continue;
                figure.getTextHolder().connect(this.getConnectedFigure().getDecoratedFigure());
            }
            return true;
        }

        public boolean redo() {
            if (!super.redo()) {
                return false;
            }
            FigureEnumeration figureEnumeration = this.getAffectedFigures();
            while (figureEnumeration.hasNextFigure()) {
                Figure figure = figureEnumeration.nextFigure();
                if (figure.getTextHolder() == null) continue;
                figure.getTextHolder().disconnect(this.getConnectedFigure().getDecoratedFigure());
            }
            return true;
        }

        public void setConnectedFigure(Figure figure) {
            this.myConnectedFigure = figure;
        }

        public Figure getConnectedFigure() {
            return this.myConnectedFigure;
        }
    }

    public static class UndoActivity
    extends TextTool.UndoActivity {
        private Figure myConnectedFigure;

        public UndoActivity(DrawingView drawingView, String string) {
            super(drawingView, string);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            FigureEnumeration figureEnumeration = this.getAffectedFigures();
            while (figureEnumeration.hasNextFigure()) {
                Figure figure = figureEnumeration.nextFigure();
                if (figure.getTextHolder() == null) continue;
                if (!this.isValidText(this.getOriginalText())) {
                    figure.getTextHolder().disconnect(this.getConnectedFigure());
                    continue;
                }
                if (this.isValidText(this.getBackupText())) continue;
                figure.getTextHolder().connect(this.getConnectedFigure());
            }
            return true;
        }

        public boolean redo() {
            if (!super.redo()) {
                return false;
            }
            FigureEnumeration figureEnumeration = this.getAffectedFigures();
            while (figureEnumeration.hasNextFigure()) {
                Figure figure = figureEnumeration.nextFigure();
                if (figure.getTextHolder() == null) continue;
                if (!this.isValidText(this.getBackupText())) {
                    figure.getTextHolder().disconnect(this.getConnectedFigure());
                    continue;
                }
                if (this.isValidText(this.getOriginalText())) continue;
                figure.getTextHolder().connect(this.getConnectedFigure());
            }
            return true;
        }

        public void setConnectedFigure(Figure figure) {
            this.myConnectedFigure = figure;
        }

        public Figure getConnectedFigure() {
            return this.myConnectedFigure;
        }
    }
}

