#!/usr/bin/env python
#----------------------------------------------------------------------------
# Project Name: MOSS
# File Name: setup.py
# Description: Installation script.
#
# Created: 2004. 08. 02
# RCS-ID: $Id: setup.py,v 1.34 2004/10/23 11:22:42 myunggoni Exp $
# Copyright: (c) 2004 by myunggoni
# License: GNU General Public License
# Author: Myung-Gon Park <myunggoni@users.kldp.net>
#----------------------------------------------------------------------------

import sys

try:
	if sys.version_info < (2, 3):
		print "MOSS requires Python 2.3 or higher"
		sys.exit(1)
except AttributeError:
	print "MOSS requires Python 2.3 or higher"
	sys.exit(1)

import os
import glob
from distutils.core import setup
from distutils.command.install_lib import install_lib
from distutils.command.install_data import install_data
from moss import __version__

installed_lib_dir = None

class my_install_lib(install_lib):
	def finalize_options(self):
		global installed_lib_dir
		install_lib.finalize_options(self)
		installed_lib_dir = self.install_dir

class my_install_data(install_data):
	def finalize_options(self):
		global installed_lib_dir
		install_data.finalize_options(self)
		
		if not os.path.isdir(os.path.join(self.install_dir, "etc")):
			print "creating %s" % os.path.join(self.install_dir, "etc")
			os.mkdir(os.path.join(self.install_dir, "etc"))
	
		if not os.path.isfile(os.path.join(self.install_dir, "etc", "moss.conf")):
			print "creating %s" % os.path.join(self.install_dir, "etc", "moss.conf")
		
			src = open("moss.conf.sample", "r")
			dest = open(os.path.join(self.install_dir, "etc", "moss.conf"), "w")

			for line in src.readlines():
				if line.find("${PREFIX}") != -1:
					line = line.replace("${PREFIX}", self.install_dir)
	
				dest.write(line)

			src.close()
			dest.close()
		else:
			if self.force:
				print "creating %s" % os.path.join(self.install_dir, "etc", "moss.conf")
			
				src = open("moss.conf.sample", "r")
				dest = open(os.path.join(self.install_dir, "etc", "moss.conf"), "w")

				for line in src.readlines():
					if line.find("${PREFIX}") != -1:
						line = line.replace("${PREFIX}", self.install_dir)
		
					dest.write(line)

				src.close()
				dest.close()
					
		if not os.path.isdir(os.path.join(self.install_dir, "var")):
			os.mkdir(os.path.join(self.install_dir, "var"))
		
		if not os.path.isdir(os.path.join(self.install_dir, "var", "log")):
			print "creating %s" % os.path.join(self.install_dir, "var", "log")
			os.mkdir(os.path.join(self.install_dir, "var", "log"))

		if not os.path.isdir(os.path.join(self.install_dir, "var", "run")):
			print "creating %s" % os.path.join(self.install_dir, "var", "run")
			os.mkdir(os.path.join(self.install_dir, "var", "run"))

		if not os.path.isdir(os.path.join(self.install_dir, "share")):
			os.mkdir(os.path.join(self.install_dir, "share"))
		
		if not os.path.isdir(os.path.join(self.install_dir, "share", "moss")):
			print "creating %s" % os.path.join(self.install_dir, "share", "moss")
			os.mkdir(os.path.join(self.install_dir, "share", "moss"))

		if not os.path.isfile(os.path.join(self.install_dir, "share", "moss", "mkpasswd.py")):
			print "changing permission %s to 0755" % (os.path.join(installed_lib_dir, "moss", "mkpasswd.py"))
			os.chmod(os.path.join(installed_lib_dir, "moss", "mkpasswd.py"), 0755)
			print "symbolic linking %s -> %s" % (os.path.join(installed_lib_dir, "moss", "mkpasswd.py"), os.path.join(self.install_dir, "share/moss/mkpasswd.py"))
			os.symlink(os.path.join(installed_lib_dir, "moss", "mkpasswd.py"), os.path.join(self.install_dir, "share/moss", "mkpasswd.py"))
		else:
			if self.force:
				print "changing permission %s to 0755" % (os.path.join(installed_lib_dir, "moss", "mkpasswd.py"))
				os.chmod(os.path.join(installed_lib_dir, "moss", "mkpasswd.py"), 0755)
				print "symbolic linking %s -> %s" % (os.path.join(installed_lib_dir, "moss", "mkpasswd.py"), os.path.join(self.install_dir, "share", "moss", "mkpasswd.py"))
				os.remove(os.path.join(self.install_dir, "share", "moss", "mkpasswd.py"))
				os.symlink(os.path.join(installed_lib_dir, "moss", "mkpasswd.py"), os.path.join(self.install_dir, "share", "moss", "mkpasswd.py"))

		if not os.path.isdir(os.path.join(self.install_dir, "bin")):
			print "creating %s" % os.path.join(self.install_dir, "bin")
			os.mkdir(os.path.join(self.install_dir, "bin"))
		
		if not os.path.isfile(os.path.join(self.install_dir, "bin", "moss")):
			print "changing permission %s to 0755" % (os.path.join(installed_lib_dir, "moss", "moss.py"))
			os.chmod(os.path.join(installed_lib_dir, "moss", "moss.py"), 0755)
			print "symbolic linking %s -> %s" % (os.path.join(installed_lib_dir, "moss", "moss.py"), os.path.join(self.install_dir, "bin", "moss"))
			os.symlink(os.path.join(installed_lib_dir, "moss", "moss.py"), os.path.join(self.install_dir, "bin", "moss"))
		else:
			if self.force:
				print "changing permission %s to 0755" % (os.path.join(installed_lib_dir, "moss", "moss.py"))
				os.chmod(os.path.join(installed_lib_dir, "moss", "moss.py"), 0755)
				print "symbolic linking %s -> %s" % (os.path.join(installed_lib_dir, "moss", "moss.py"), os.path.join(self.install_dir, "bin", "moss"))
				os.remove(os.path.join(self.install_dir, "bin", "moss"))
				os.symlink(os.path.join(installed_lib_dir, "moss", "moss.py"), os.path.join(self.install_dir, "bin", "moss"))
		
if __name__ == "__main__":
	setup(
	name = "moss",
	version = __version__,
	license = "GNU Generic Public License",
	url = "http://moss.kldp.net",
	author = "Myung-Gon Park",
	author_email = "myunggoni@users.kldp.net",
	platforms = ["POSIX"],
	keywords = ["Streaming Audio Server"],
	description = "HTTP-Based Streaming Audio Server Written in Python",
	long_description = "MOSS is the initial letters of the 'MP3/OGG Streaming Server'\n"
			"and an HTTP-based streaming audio server written in Python.\n"
			"It supports the web mode where you browse and select songs\n"
			"and the live mode which supports real-time broadcast.",
	download_url = "http://kldp.net/project/showfiles.php?group_id=469",
	packages = ["moss"],
	package_dir = {"moss": ""},
	data_files = [
	("share/moss", ["moss.conf.sample"]),
	("share/moss/images", glob.glob("images/*")),
	("share/moss/templates", glob.glob("templates/*.tmpl"))],
	cmdclass = {"install_lib" : my_install_lib,
		"install_data" : my_install_data}
	)
