#!/bin/bash

# This scripty runs through all the combinations of MTL
# matrix types, compiles the test suite for each, and runs the
# test suite for a bunch of different sizes of the matrix.
# This takes a considerably long time to run, since there
# are literally thousands of combinations of MTL matrices.
# There are actually a total of XXXX tests that are run.


# particular headaches were handling the angle brackets
# necessary to put in the templated type arguments


#fills some arrays and vars
 MTLNUMS="double:complex<double>"
 RECT_STORAGE="compressed<>:array<linked_list>:array< compressed<> >:array<sparse_pair>:array<tree>:array< dense<> >:dense<>"
 BANDED_SHAPES="triangle<unit_lower>:triangle<lower>:symmetric<lower>:diagonal<>:symmetric<upper>:triangle<upper>:triangle<unit_upper>:banded<>"
 BANDED_STORAGE="packed<>:array< dense<> >:banded<>:banded_view<>"
 ORIENS="row_major:column_major"


quick_algorithms=1

cd src

run_matrix_test() {

  test_programs=`cat qtest`

  if [ $quick_algorithms -ne 1 ]; then
    test_programs=`cat alltests`
  fi

  for program in $test_programs; do

    /bin/rm -rf $program $program.exe

    /bin/rm -rf make.log
    make $program > make.log 2>&1

    warn_count=`grep "warning:" make.log | wc -l` 
     err_count=`grep "error:" make.log | wc -l` 

    build_result="FAILURE"
    if [ -f $program -o -f $program.exe ]; then
      build_result="SUCCESS"
    fi

    echo "%BUILD: NUMTYPE SHAPE STORAGE ORIEN TESTNAME WARN ERR"
    echo "%NUMTYPE: $1"
    echo "%SHAPE: $2"
    echo "%STORAGE: $3"
    echo "%ORIEN: $4"
    echo "%TESTNAME: $program"
    echo "%WARN: $warn_count"
    echo "%ERR: $err_count"
    echo "%RESULT: $build_result"

    if [ $warn_count -ne 0 -o $err_count -ne 0 -o $build_result == "FAILURE" ]; then
	cat make.log 
    fi

    echo ""
    echo ""
    
    if [ -f $program -o -f $program.exe ]; then

      m=10
      nn=10
      
      while [ $m -lt 50 ]; do
        while [ $nn -lt 50 ]; do
	  sub=`expr $m - 1`
	  sup=`expr $nn - 1`

	  while [ $sub -ge 0 -a $sup -ge 0 ]; do
            echo "%TEST: M N SUB SUPER"
	    echo "%M: $m"
	    echo "%N: $nn"
	    echo "%SUB: $sub"
	    echo "%SUPER: $sup"

	    /bin/rm -rf run.log
	    ./$program $m $nn $sub $sup > run.log 2>&1

	    runFail=0
	    if [ "`grep -i seg run.log`" != "" ]; then
		runFail=1
	    fi

	    if [ "`grep -i abort run.log`" != "" ]; then
		runFail=1
	    fi

	    if [ "`grep -i bus run.log`" != "" ]; then
	       runFail=1
	    fi

	    if [ "`grep -i fail run.log`" != "" ]; then
	     runFail=1
	    fi


	    if [ $runFail != 0 ]; then
		echo "%RESULT: FAILURE"
		cat run.log
	    else 
		echo "%RESULT: SUCCESS"
	    fi

	    echo ""

	    sup=`expr $sup - $sup / 2 - 1`
	    sub=`expr $sub - $sub / 2 - 1`
	  done
          nn=`expr $nn + 7`
       done
       m=`expr $m + 7`
     done
   fi
  done
}



#require RECT_STORAGE

rect_dense() {

# rectangle dense matrices
    local_storage=$RECT_STORAGE
    local_orients=$ORIENS
    local_mtlnums=$MTLNUMS

    while [ "$local_storage" != "" ]; do

      s=`echo $local_storage|cut -d':' -f1`
      local_storage=`echo $local_storage|cut -d':' -f2-100`

      while [ "$local_orients" != "" ]; do

	o=`echo $local_orients|cut -d':' -f1`
	local_orients=`echo $local_orients|cut -d':' -f2-100`      

	while [ "$local_mtlnums" != "" ]; do

	    n=`echo $local_mtlnums|cut -d':' -f1`
	    local_mtlnums=`echo $local_mtlnums|cut -d':' -f2-100`      

	    shape="rectangle<>";

	    tmp=`echo $s | /bin/sed -e s/\</_/g | /bin/sed -e s/\>/_/g`
	    tmp1=`echo $n | /bin/sed -e s/\</_/g | /bin/sed -e s/\>/_/g`
	    name=`echo $tmp $o tmp1`
	    name=`echo $name | /bin/sed -e s/\ /_/g`

	    /bin/rm -rf matrix_attr.h
	    touch  matrix_attr.h
	    echo "#ifndef MATRIX_ATTR_H"       >>  matrix_attr.h  
	    echo "#define MATRIX_ATTR_H"       >>  matrix_attr.h  
	    echo "#define NUMTYPE $n"          >>  matrix_attr.h  
	    echo "#define SHAPE $shape"        >>  matrix_attr.h  
	    echo "#define STORAGE $s"          >>  matrix_attr.h  
	    echo "#define ORIEN $o"            >>  matrix_attr.h  
	    echo "#define TESTNAME \"$name\""  >>  matrix_attr.h  
	    echo "#endif /* MATRIX_ATTR_H */"  >>  matrix_attr.h  

	    run_matrix_test $n $shape $s $o
	done
      done
   done
}


banded_and_diagonal() {
# banded and diagonal dense matrices

  local_orients=$ORIENS          
  local_mtlnums=$MTLNUMS     
  local_banded_storage=$BANDED_STORAGE
  local_banded_shapes=BANDED_DHAPES

  while [ "$local_orients" != "" ]; do

    o=`echo $local_orients|cut -d':' -f1`
    local_orients=`echo $local_orients|cut -d':' -f2-100`

    while [ "$local_mtlnums" != "" ]; do
 
      n=`echo $local_mtlnums|cut -d':' -f1`
      local_mtlnums=`echo $local_mtlnums|cut -d':' -f2-100`

      while [ "$local_banded_storage" != "" ]; do

        s=`echo $local_banded_storage|cut -d':' -f1`
	local_banded_storage=`echo $local_banded_storage|cut -d':' -f2-100` 

      while [ "$local_banded_shapes" != "" ]; do

        shape=`echo $local_banded_shapes|cut -d':' -f1`
	local_banded_shapes=`echo $local_banded_shapes|cut -d':' -f2-100` 

        tmp1=`echo $n | /bin/sed -e s/\</_/g | /bin/sed -e s/\>/_/g`	
        tmp=`echo $shape | /bin/sed -e s/\</_/g | /bin/sed -e s/\>/_/g`

	name=`echo $tmp tmp1`

        tmp=`echo $s | /bin/sed -e s/\</_/g | /bin/sed -e s/\>/_/g`

	name=`echo $name $tmp`	
        name=`echo $name | /bin/sed -e s/\ /_/g`     


            /bin/rm -rf matrix_attr.h
            touch  matrix_attr.h
            echo "#ifndef MATRIX_ATTR_H"       >>  matrix_attr.h
            echo "#define MATRIX_ATTR_H"       >>  matrix_attr.h
            echo "#define NUMTYPE $n"          >>  matrix_attr.h
            echo "#define SHAPE $shape"        >>  matrix_attr.h
            echo "#define STORAGE $s"          >>  matrix_attr.h
            echo "#define ORIEN $o"            >>  matrix_attr.h
            echo "#define TESTNAME \"$name\""  >>  matrix_attr.h
            echo "#endif /* MATRIX_ATTR_H */"  >>  matrix_attr.h

	run_matrix_test $n $shape $s $o
      done
      done
   done
  done
}



#/bin/rm -rf make_and_test_results.txt
#touch make_and_test_results.txt

#$info_string = "%CONFIG: ARCH OS COMPILER FLAGS
#%%ARCH: @ARGV[0]
#%%OS: @ARGV[1]
#%%COMPILER: @ARGV[2]
#%%FLAGS: @ARGV[3..$#ARGV] 
#";

#printf(OUTF "$info_string\n\n");

#$opt_d = ".";
#getopts('qQd:p');
#chdir "$opt_d";




/bin/rm -rf *.o

quick_types=1

if [ "$1" != "-p" ]; then
    if [ "$1" == "-Q" ]; then
	quick_types=0
	quick_algorithms=1
    elif [ "$1" == "-q" ]; then
	quick_types=1
	quick_algorithms=0
    elif [ "$1" == "-qQ" ]; then
	quick_types=1
	quick_algorithms=1
    else
	quick_types=0
	quick_algorithms=0
    fi

  if [ $quick_types -eq 1 ]; then
      MTLNUMS="`echo $MTLNUMS|cut -d':' -f1`"
      RECT_STORAGE="`echo $RECT_STORAGE | cut -d':' -f1`"
      BANDED_SHAPES="`echo $BANDED_SHAPES|cut -d':' -f1`"
      BANDED_STORAGE="`echo $BANDED_STORAGE|cut -d':' -f1`"
      ORIENS="`echo $ORIENS|cut -d':' -f1`"
  fi
  
  rect_dense
  banded_and_diagonal
  
else 

  quick_types=0
  quick_algorithms=1  

  rect_dense
  banded_and_diagonal

  quick_types=1
  quick_algorithms=0


  if [ $quick_types -eq 1 ]; then
      MTLNUMS="`echo $MTLNUMS|cut -d':' -f1`"
      RECT_STORAGE="`echo $RECT_STORAGE | cut -d':' -f1`"
      BANDED_SHAPES="`echo $BANDED_SHAPES|cut -d':' -f1`"
      BANDED_STORAGE="`echo $BANDED_STORAGE|cut -d':' -f1`"
      ORIENS="`echo $ORIENS|cut -d':' -f1`"
  fi

  rect_dense
  banded_and_diagonal

fi

