: # *-*-perl-*-*
    eval 'exec perl -S  $0 "$@"'
    if $running_under_some_shell;

# Called with
# @ARGV = config_failed arch os compiler config
#
# Input and output files are hardwired -- they should be parameterized
#


use Getopt::Std;

$opt_d = ".";
getopts('d:');


open(OUTF,">config_results.txt");

chdir "$opt_d";

open(INF, "<config.status"); 

$host = Unknown;
$arch = Unknown;
$os = Unknown;
$compiler = Unknown;
$flags = Unknown;

while (<INF>) {
  if (/on host (.*):/) {
    $host = $1;

    $xx = <INF>;
    $yy = <INF>;
    
    $yy =~ s/#\sconfigure\s//;
    $flags = $yy;
  }

  if (/target_cpu@%(.*)%/) {
    $arch = $1;
  }

  if (/target_os@%(.*)%/) {
    $os = $1;
  }

  if (/CXX@%(.*)%/) {
    $compiler = $1;
  }


}

close INF;

print OUTF "%CONFIG: HOST ARCH OS COMPILER FLAGS\n";
print OUTF "%HOST: $host\n";
print OUTF "%ARCH: $arch\n";
print OUTF "%OS: $os\n";
print OUTF "%COMPILER: $compiler\n";
print OUTF "%FLAGS: $flags";

if (@ARGV[0] == 0) {
  $result = "SUCCESS";
} else {
  $result = "FAILURE";
}
print OUTF "%RESULT: $result\n";

if ($result eq "FAILURE") {
  print OUTF "======== config.log ========\n";
  open(INCLUDE,"<config.log");
  while (<INCLUDE>) {
    print OUTF <INCLUDE>;
  }
  print OUTF "================\n\n";
  close INCLUDE;

  print OUTF "======== config.status ========\n";
  open(INCLUDE,"<config.status");
  while (<INCLUDE>) {
    print OUTF <INCLUDE>;
  }
  print OUTF "================\n";
  close INCLUDE;
}

close(OUTF);
