: # *-*-perl-*-*
    eval 'exec perl -S  $0 "$@"'
    if $running_under_some_shell;


# Called with
# @ARGV = arch os compiler config
#
# Input and output files are hardwired -- they should be parameterized
#


format My_Top_Format =
S   ARCH   OS          CXX  FLAGS                      FM CF      BUILDS WARNINGS   ERRORS           TESTS
----------------------------------------------------------------------------------------------------------
.
    
    format My_Other_Format = 
@<< @<<<<< @<<<<<<<<<< @<<< @<<<<<<<<<<<<<<<<<<<<<<<<< @> @> @>>>>>>>>>> @>>>>>>> @>>>>>>> @>>>>>>>>>>>>>>
$subdir, $arch, $os,    $compiler,$flags,       $farm,  $conf, $builds, $build_warnings, $build_errors, $tests
.


open (OUTF, ">-");

use FileHandle;
format_name     OUTF "My_Other_Format";
format_top_name OUTF "My_Top_Format";


foreach $subdir ( @ARGV ) {
  
  $bad_farms = 0;
  $good_builds = 0;
  $bad_builds = 0;
  $bad_execs = 0;
  $good_execs = 0;
  $good_tests = 0;
  $bad_tests = 0;
  $build_warnings = 0;
  $build_errors = 0;

  $arch = "";
  $os = "";
  $compiler = "";
  $flags = "None";
  $farm = 0;
  $conf = 0;

  $built_result_errs = 0;
  $test_result_errs = 0;
  
  if (-d $subdir) {
    
    if (-f "$subdir/LOG") {
      $loglines = "";
      open(INF, "<$subdir/LOG");
      while (<INF>) {
	$loglines .= $_;
      }
      close(INF);
      @loglines = split(/\n/, $loglines);
      
      $num_loglines = scalar(@loglines);

      if ($num_loglines != 6) {
	print "Something is wrong with LOG file";
	print "$num_loglines";
        $farm = 0;
      } else { 
        $farm = 1; 
      }
    }

    if (-f "$subdir/config_results.txt") {
      open(INF, "<$subdir/config_results.txt");
      while (<INF>) {

      if (/^%ARCH/) {
	@rfields = split(' ');
        $arch = @rfields[1];
      }
      if (/^%OS/) {
	@rfields = split(' ');
        $os = @rfields[1];
      }
      if (/^%COMPILER/) {
	@rfields = split(' ');
        $compiler = @rfields[1];
      }
      if (/^%FLAGS/) {
	@rfields = split(':');
        $flags = @rfields[1];
        $flags =~ s/\#//; 
        $flags =~ s/\s//; 
        $flags =~ s/.*configure\s//; 
      }
      if (/^%RESULT/) {
	  @rfields = split(' ');
	  if (@rfields[1] eq "FAILURE") {
	    $conf = 0;
	  } elsif (@rfields[1] eq "SUCCESS") {
	    $conf = 1;
	  } else {
	    $conf = "?";
	  }
	}
      }
      close(INF);
    } else {
      print "Missing config\n";
    }

    if (-f "$subdir/make_and_test_results.txt") {
      open(INF, "<$subdir/make_and_test_results.txt");
      while (<INF>) {

      if (/^%BUILD/) {
	while (<INF>) {
	  if (/^%WARN/) {
	    @rfields = split(' ');
            $build_warnings += @rfields[1];
          }
	  if (/^%ERR/) {
	    @rfields = split(' ');
            $build_errors += @rfields[1];
          }
	  if (/^%RESULT/) {
	    @rfields = split(' ');
	    if (@rfields[1] eq "FAILURE") {
	      $bad_builds++;
	    } elsif (@rfields[1] eq "SUCCESS") {
	      $good_builds++;
	    } else {
	      $build_result_errs++;
	    }
            last;
	  }
	}
      }
      
      if (/^%TEST/) {
	while (<INF>) {
	  if (/^%RESULT/) {
	    @rfields = split(' ');
	    if (@rfields[1] eq "FAILURE") {
	      $bad_tests++;
	    } elsif (@rfields[1] eq "SUCCESS") {
	      $good_tests++;
	    } else {
	      $test_result_errs++;
	    }
            last;
	  }
	}
      }
      }      
      
      close(INF);
    } else {
      print "No make_and_test_results.txt\n";
    }
    
    $sum_builds = $good_builds + $bad_builds;
    $builds = "$good_builds/$sum_builds";
    if ($build_result_errs > 0) {
      $builds .= "?";
    }
    
    $sum_tests = $good_tests + $bad_tests;
    $tests = "$good_tests/$sum_tests";
    if ($test_result_errs > 0) {
      $tests .= "?";
    }
    
    write OUTF;
  }
}

close(OUTF);
