/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#include "../rpc_server/db_server.h"
#include <stdio.h>
#include <stdlib.h> /* getenv, exit */
#include <signal.h>
#include <sys/types.h>
#include <memory.h>
#include <stropts.h>
#include <netconfig.h>
#include <sys/resource.h> /* rlimit */
#include <syslog.h>

#ifdef DEBUG
#define	RPC_SVC_FG
#endif

#define	_RPCSVC_CLOSEDOWN 120
static int _rpcpmstart;		/* Started by a port monitor ? */

/* States a server can be in wrt request */

#define	_IDLE 0
#define	_SERVED 1

static int _rpcsvcstate = _IDLE;	/* Set when a request is serviced */
static int _rpcsvccount = 0;		/* Number of requests being serviced */

static
void _msgout(msg)
	char *msg;
{
#ifdef RPC_SVC_FG
	if (_rpcpmstart)
		syslog(LOG_ERR, "%s", msg);
	else
		(void) fprintf(stderr, "%s\n", msg);
#else
	syslog(LOG_ERR, "%s", msg);
#endif
}

static void
closedown(sig)
	int sig;
{
	if (_rpcsvcstate == _IDLE && _rpcsvccount == 0) {
		int size;
		int i, openfd = 0;

		size = svc_max_pollfd;
		for (i = 0; i < size && openfd < 2; i++)
			if (svc_pollfd[i].fd >= 0)
				openfd++;
		if (openfd <= 1)
			exit(0);
	} else
		_rpcsvcstate = _IDLE;

	(void) signal(SIGALRM, (void(*)()) closedown);
	(void) alarm(_RPCSVC_CLOSEDOWN/2);
}

static void
db_rpc_serverprog_4001(rqstp, transp)
	struct svc_req *rqstp;
	register SVCXPRT *transp;
{
	union {
		__env_cachesize_msg __db_env_cachesize_4001_arg;
		__env_close_msg __db_env_close_4001_arg;
		__env_create_msg __db_env_create_4001_arg;
		__env_dbremove_msg __db_env_dbremove_4001_arg;
		__env_dbrename_msg __db_env_dbrename_4001_arg;
		__env_encrypt_msg __db_env_encrypt_4001_arg;
		__env_flags_msg __db_env_flags_4001_arg;
		__env_open_msg __db_env_open_4001_arg;
		__env_remove_msg __db_env_remove_4001_arg;
		__txn_abort_msg __db_txn_abort_4001_arg;
		__txn_begin_msg __db_txn_begin_4001_arg;
		__txn_commit_msg __db_txn_commit_4001_arg;
		__txn_discard_msg __db_txn_discard_4001_arg;
		__txn_prepare_msg __db_txn_prepare_4001_arg;
		__txn_recover_msg __db_txn_recover_4001_arg;
		__db_associate_msg __db_db_associate_4001_arg;
		__db_bt_maxkey_msg __db_db_bt_maxkey_4001_arg;
		__db_bt_minkey_msg __db_db_bt_minkey_4001_arg;
		__db_close_msg __db_db_close_4001_arg;
		__db_create_msg __db_db_create_4001_arg;
		__db_del_msg __db_db_del_4001_arg;
		__db_encrypt_msg __db_db_encrypt_4001_arg;
		__db_extentsize_msg __db_db_extentsize_4001_arg;
		__db_flags_msg __db_db_flags_4001_arg;
		__db_get_msg __db_db_get_4001_arg;
		__db_h_ffactor_msg __db_db_h_ffactor_4001_arg;
		__db_h_nelem_msg __db_db_h_nelem_4001_arg;
		__db_key_range_msg __db_db_key_range_4001_arg;
		__db_lorder_msg __db_db_lorder_4001_arg;
		__db_open_msg __db_db_open_4001_arg;
		__db_pagesize_msg __db_db_pagesize_4001_arg;
		__db_pget_msg __db_db_pget_4001_arg;
		__db_put_msg __db_db_put_4001_arg;
		__db_re_delim_msg __db_db_re_delim_4001_arg;
		__db_re_len_msg __db_db_re_len_4001_arg;
		__db_re_pad_msg __db_db_re_pad_4001_arg;
		__db_remove_msg __db_db_remove_4001_arg;
		__db_rename_msg __db_db_rename_4001_arg;
		__db_stat_msg __db_db_stat_4001_arg;
		__db_sync_msg __db_db_sync_4001_arg;
		__db_truncate_msg __db_db_truncate_4001_arg;
		__db_cursor_msg __db_db_cursor_4001_arg;
		__db_join_msg __db_db_join_4001_arg;
		__dbc_close_msg __db_dbc_close_4001_arg;
		__dbc_count_msg __db_dbc_count_4001_arg;
		__dbc_del_msg __db_dbc_del_4001_arg;
		__dbc_dup_msg __db_dbc_dup_4001_arg;
		__dbc_get_msg __db_dbc_get_4001_arg;
		__dbc_pget_msg __db_dbc_pget_4001_arg;
		__dbc_put_msg __db_dbc_put_4001_arg;
	} argument;
	char *result;
	bool_t (*_xdr_argument)(), (*_xdr_result)();
	char *(*local)();

	_rpcsvccount++;
	switch (rqstp->rq_proc) {
	case NULLPROC:
		(void) svc_sendreply(transp, (xdrproc_t)xdr_void,
			(char *)NULL);
		_rpcsvccount--;
		_rpcsvcstate = _SERVED;
		return;

	case __DB_env_cachesize:
		_xdr_argument = xdr___env_cachesize_msg;
		_xdr_result = xdr___env_cachesize_reply;
		local = (char *(*)()) __db_env_cachesize_4001;
		break;

	case __DB_env_close:
		_xdr_argument = xdr___env_close_msg;
		_xdr_result = xdr___env_close_reply;
		local = (char *(*)()) __db_env_close_4001;
		break;

	case __DB_env_create:
		_xdr_argument = xdr___env_create_msg;
		_xdr_result = xdr___env_create_reply;
		local = (char *(*)()) __db_env_create_4001;
		break;

	case __DB_env_dbremove:
		_xdr_argument = xdr___env_dbremove_msg;
		_xdr_result = xdr___env_dbremove_reply;
		local = (char *(*)()) __db_env_dbremove_4001;
		break;

	case __DB_env_dbrename:
		_xdr_argument = xdr___env_dbrename_msg;
		_xdr_result = xdr___env_dbrename_reply;
		local = (char *(*)()) __db_env_dbrename_4001;
		break;

	case __DB_env_encrypt:
		_xdr_argument = xdr___env_encrypt_msg;
		_xdr_result = xdr___env_encrypt_reply;
		local = (char *(*)()) __db_env_encrypt_4001;
		break;

	case __DB_env_flags:
		_xdr_argument = xdr___env_flags_msg;
		_xdr_result = xdr___env_flags_reply;
		local = (char *(*)()) __db_env_flags_4001;
		break;

	case __DB_env_open:
		_xdr_argument = xdr___env_open_msg;
		_xdr_result = xdr___env_open_reply;
		local = (char *(*)()) __db_env_open_4001;
		break;

	case __DB_env_remove:
		_xdr_argument = xdr___env_remove_msg;
		_xdr_result = xdr___env_remove_reply;
		local = (char *(*)()) __db_env_remove_4001;
		break;

	case __DB_txn_abort:
		_xdr_argument = xdr___txn_abort_msg;
		_xdr_result = xdr___txn_abort_reply;
		local = (char *(*)()) __db_txn_abort_4001;
		break;

	case __DB_txn_begin:
		_xdr_argument = xdr___txn_begin_msg;
		_xdr_result = xdr___txn_begin_reply;
		local = (char *(*)()) __db_txn_begin_4001;
		break;

	case __DB_txn_commit:
		_xdr_argument = xdr___txn_commit_msg;
		_xdr_result = xdr___txn_commit_reply;
		local = (char *(*)()) __db_txn_commit_4001;
		break;

	case __DB_txn_discard:
		_xdr_argument = xdr___txn_discard_msg;
		_xdr_result = xdr___txn_discard_reply;
		local = (char *(*)()) __db_txn_discard_4001;
		break;

	case __DB_txn_prepare:
		_xdr_argument = xdr___txn_prepare_msg;
		_xdr_result = xdr___txn_prepare_reply;
		local = (char *(*)()) __db_txn_prepare_4001;
		break;

	case __DB_txn_recover:
		_xdr_argument = xdr___txn_recover_msg;
		_xdr_result = xdr___txn_recover_reply;
		local = (char *(*)()) __db_txn_recover_4001;
		break;

	case __DB_db_associate:
		_xdr_argument = xdr___db_associate_msg;
		_xdr_result = xdr___db_associate_reply;
		local = (char *(*)()) __db_db_associate_4001;
		break;

	case __DB_db_bt_maxkey:
		_xdr_argument = xdr___db_bt_maxkey_msg;
		_xdr_result = xdr___db_bt_maxkey_reply;
		local = (char *(*)()) __db_db_bt_maxkey_4001;
		break;

	case __DB_db_bt_minkey:
		_xdr_argument = xdr___db_bt_minkey_msg;
		_xdr_result = xdr___db_bt_minkey_reply;
		local = (char *(*)()) __db_db_bt_minkey_4001;
		break;

	case __DB_db_close:
		_xdr_argument = xdr___db_close_msg;
		_xdr_result = xdr___db_close_reply;
		local = (char *(*)()) __db_db_close_4001;
		break;

	case __DB_db_create:
		_xdr_argument = xdr___db_create_msg;
		_xdr_result = xdr___db_create_reply;
		local = (char *(*)()) __db_db_create_4001;
		break;

	case __DB_db_del:
		_xdr_argument = xdr___db_del_msg;
		_xdr_result = xdr___db_del_reply;
		local = (char *(*)()) __db_db_del_4001;
		break;

	case __DB_db_encrypt:
		_xdr_argument = xdr___db_encrypt_msg;
		_xdr_result = xdr___db_encrypt_reply;
		local = (char *(*)()) __db_db_encrypt_4001;
		break;

	case __DB_db_extentsize:
		_xdr_argument = xdr___db_extentsize_msg;
		_xdr_result = xdr___db_extentsize_reply;
		local = (char *(*)()) __db_db_extentsize_4001;
		break;

	case __DB_db_flags:
		_xdr_argument = xdr___db_flags_msg;
		_xdr_result = xdr___db_flags_reply;
		local = (char *(*)()) __db_db_flags_4001;
		break;

	case __DB_db_get:
		_xdr_argument = xdr___db_get_msg;
		_xdr_result = xdr___db_get_reply;
		local = (char *(*)()) __db_db_get_4001;
		break;

	case __DB_db_h_ffactor:
		_xdr_argument = xdr___db_h_ffactor_msg;
		_xdr_result = xdr___db_h_ffactor_reply;
		local = (char *(*)()) __db_db_h_ffactor_4001;
		break;

	case __DB_db_h_nelem:
		_xdr_argument = xdr___db_h_nelem_msg;
		_xdr_result = xdr___db_h_nelem_reply;
		local = (char *(*)()) __db_db_h_nelem_4001;
		break;

	case __DB_db_key_range:
		_xdr_argument = xdr___db_key_range_msg;
		_xdr_result = xdr___db_key_range_reply;
		local = (char *(*)()) __db_db_key_range_4001;
		break;

	case __DB_db_lorder:
		_xdr_argument = xdr___db_lorder_msg;
		_xdr_result = xdr___db_lorder_reply;
		local = (char *(*)()) __db_db_lorder_4001;
		break;

	case __DB_db_open:
		_xdr_argument = xdr___db_open_msg;
		_xdr_result = xdr___db_open_reply;
		local = (char *(*)()) __db_db_open_4001;
		break;

	case __DB_db_pagesize:
		_xdr_argument = xdr___db_pagesize_msg;
		_xdr_result = xdr___db_pagesize_reply;
		local = (char *(*)()) __db_db_pagesize_4001;
		break;

	case __DB_db_pget:
		_xdr_argument = xdr___db_pget_msg;
		_xdr_result = xdr___db_pget_reply;
		local = (char *(*)()) __db_db_pget_4001;
		break;

	case __DB_db_put:
		_xdr_argument = xdr___db_put_msg;
		_xdr_result = xdr___db_put_reply;
		local = (char *(*)()) __db_db_put_4001;
		break;

	case __DB_db_re_delim:
		_xdr_argument = xdr___db_re_delim_msg;
		_xdr_result = xdr___db_re_delim_reply;
		local = (char *(*)()) __db_db_re_delim_4001;
		break;

	case __DB_db_re_len:
		_xdr_argument = xdr___db_re_len_msg;
		_xdr_result = xdr___db_re_len_reply;
		local = (char *(*)()) __db_db_re_len_4001;
		break;

	case __DB_db_re_pad:
		_xdr_argument = xdr___db_re_pad_msg;
		_xdr_result = xdr___db_re_pad_reply;
		local = (char *(*)()) __db_db_re_pad_4001;
		break;

	case __DB_db_remove:
		_xdr_argument = xdr___db_remove_msg;
		_xdr_result = xdr___db_remove_reply;
		local = (char *(*)()) __db_db_remove_4001;
		break;

	case __DB_db_rename:
		_xdr_argument = xdr___db_rename_msg;
		_xdr_result = xdr___db_rename_reply;
		local = (char *(*)()) __db_db_rename_4001;
		break;

	case __DB_db_stat:
		_xdr_argument = xdr___db_stat_msg;
		_xdr_result = xdr___db_stat_reply;
		local = (char *(*)()) __db_db_stat_4001;
		break;

	case __DB_db_sync:
		_xdr_argument = xdr___db_sync_msg;
		_xdr_result = xdr___db_sync_reply;
		local = (char *(*)()) __db_db_sync_4001;
		break;

	case __DB_db_truncate:
		_xdr_argument = xdr___db_truncate_msg;
		_xdr_result = xdr___db_truncate_reply;
		local = (char *(*)()) __db_db_truncate_4001;
		break;

	case __DB_db_cursor:
		_xdr_argument = xdr___db_cursor_msg;
		_xdr_result = xdr___db_cursor_reply;
		local = (char *(*)()) __db_db_cursor_4001;
		break;

	case __DB_db_join:
		_xdr_argument = xdr___db_join_msg;
		_xdr_result = xdr___db_join_reply;
		local = (char *(*)()) __db_db_join_4001;
		break;

	case __DB_dbc_close:
		_xdr_argument = xdr___dbc_close_msg;
		_xdr_result = xdr___dbc_close_reply;
		local = (char *(*)()) __db_dbc_close_4001;
		break;

	case __DB_dbc_count:
		_xdr_argument = xdr___dbc_count_msg;
		_xdr_result = xdr___dbc_count_reply;
		local = (char *(*)()) __db_dbc_count_4001;
		break;

	case __DB_dbc_del:
		_xdr_argument = xdr___dbc_del_msg;
		_xdr_result = xdr___dbc_del_reply;
		local = (char *(*)()) __db_dbc_del_4001;
		break;

	case __DB_dbc_dup:
		_xdr_argument = xdr___dbc_dup_msg;
		_xdr_result = xdr___dbc_dup_reply;
		local = (char *(*)()) __db_dbc_dup_4001;
		break;

	case __DB_dbc_get:
		_xdr_argument = xdr___dbc_get_msg;
		_xdr_result = xdr___dbc_get_reply;
		local = (char *(*)()) __db_dbc_get_4001;
		break;

	case __DB_dbc_pget:
		_xdr_argument = xdr___dbc_pget_msg;
		_xdr_result = xdr___dbc_pget_reply;
		local = (char *(*)()) __db_dbc_pget_4001;
		break;

	case __DB_dbc_put:
		_xdr_argument = xdr___dbc_put_msg;
		_xdr_result = xdr___dbc_put_reply;
		local = (char *(*)()) __db_dbc_put_4001;
		break;

	default:
		svcerr_noproc(transp);
		_rpcsvccount--;
		_rpcsvcstate = _SERVED;
		return;
	}
	(void) memset((char *)&argument, 0, sizeof (argument));
	if (!svc_getargs(transp, _xdr_argument, (caddr_t) &argument)) {
		svcerr_decode(transp);
		_rpcsvccount--;
		_rpcsvcstate = _SERVED;
		return;
	}
	result = (*local)(&argument, rqstp);
	if (_xdr_result && result != NULL && !svc_sendreply(transp, _xdr_result, result)) {
		svcerr_systemerr(transp);
	}
	if (!svc_freeargs(transp, _xdr_argument, (caddr_t) &argument)) {
		_msgout("unable to free arguments");
		exit(1);
	}
	_rpcsvccount--;
	_rpcsvcstate = _SERVED;
	__dbsrv_timeout(0);
	return;
}

void __dbsrv_main()
{
	pid_t pid;
	int i;

	(void) sigset(SIGPIPE, SIG_IGN);

	/*
	 * If stdin looks like a TLI endpoint, we assume
	 * that we were started by a port monitor. If
	 * t_getstate fails with TBADF, this is not a
	 * TLI endpoint.
	 */
	if (t_getstate(0) != -1 || t_errno != TBADF) {
		char *netid;
		struct netconfig *nconf = NULL;
		SVCXPRT *transp;
		int pmclose;

		_rpcpmstart = 1;
		openlog("../rpc_server/db_server", LOG_PID, LOG_DAEMON);

		if ((netid = getenv("NLSPROVIDER")) == NULL) {
		/* started from inetd */
			pmclose = 1;
		} else {
			if ((nconf = getnetconfigent(netid)) == NULL)
				_msgout("cannot get transport info");

			pmclose = (t_getstate(0) != T_DATAXFER);
		}
		if ((transp = svc_tli_create(0, nconf, NULL, 0, 0)) == NULL) {
			_msgout("cannot create server handle");
			exit(1);
		}
		if (nconf)
			freenetconfigent(nconf);
		if (!svc_reg(transp, DB_RPC_SERVERPROG, DB_RPC_SERVERVERS, db_rpc_serverprog_4001, 0)) {
			_msgout("unable to register (DB_RPC_SERVERPROG, DB_RPC_SERVERVERS).");
			exit(1);
		}
		if (pmclose) {
			(void) signal(SIGALRM, (void(*)()) closedown);
			(void) alarm(_RPCSVC_CLOSEDOWN/2);
		}
		svc_run();
		exit(1);
		/* NOTREACHED */
	}	else {
#ifndef RPC_SVC_FG
#pragma weak closefrom
		extern void closefrom();
		int size;
		struct rlimit rl;
		pid = fork();
		if (pid < 0) {
			perror("cannot fork");
			exit(1);
		}
		if (pid)
			exit(0);
		if (closefrom != NULL)
			closefrom(0);
		else {
			rl.rlim_max = 0;
			getrlimit(RLIMIT_NOFILE, &rl);
			if ((size = rl.rlim_max) == 0)
				exit(1);
			for (i = 0; i < size; i++)
				(void) close(i);
		}
		i = open("/dev/null", 2);
		(void) dup2(i, 1);
		(void) dup2(i, 2);
		setsid();
		openlog("../rpc_server/db_server", LOG_PID, LOG_DAEMON);
#endif
	}
	if (!svc_create(db_rpc_serverprog_4001, DB_RPC_SERVERPROG, DB_RPC_SERVERVERS, "tcp")) {
		_msgout("unable to create (DB_RPC_SERVERPROG, DB_RPC_SERVERVERS) for tcp.");
		exit(1);
	}

	svc_run();
	_msgout("svc_run returned");
	exit(1);
	/* NOTREACHED */
}
