#ifndef _NAP_CMDS_H
#define _NAP_CMDS_H

/* Copyright (c) 2000  Kevin Sullivan <nite@gis.net>
 *
 * Please refer to the COPYRIGHT file for more information.
 */

#include <sys/time.h>

#include "scheck.h"


struct in_nap_cmd_s 
{
  unsigned short op;
  int (*func)(int, char *, char **, int, WINDOW *);
};
typedef struct in_nap_cmd_s in_nap_cmd_t;

struct out_nap_cmd_s 
{
  char *nm;
  unsigned char a;
  int (*func)(int, char *, char **, int, WINDOW *);
  char *help;
};
typedef struct out_nap_cmd_s out_nap_cmd_t;

struct user_s 
{
  char *nm, *addr;
  unsigned char conn;
  unsigned int scount;
  unsigned char flag;
  struct user_s *next;
};
typedef struct user_s user_t;

struct hotlist_s 
{
  char *nm;
  int conn;
  unsigned char on;
};
typedef struct hotlist_s hotlist_t;

struct chans_s 
{
  char *nm;
  char *topic;
  user_t *users;
  unsigned char q;
  unsigned char flag;
  int l;
  char *key;
  unsigned char p;
  struct chans_s *next;
}; 
typedef struct chans_s chans_t;

struct ssearch_s 
{
  char *song;
  char *fn;
  char *cmp;
  int conn;
  unsigned int sz;
  int brate;
  int freq;
  int time;
  int num;
  unsigned long ip;
  struct timeval s, r;
  int ping;
  struct ssearch_s *next;
};
typedef struct ssearch_s ssearch_t;

struct file_s 
{
  unsigned long addr;
  unsigned short port;
  time_t st;
  FILE *f;
  char *fn;
  char *nm;
  char *rfn;
  void *timer;
  unsigned long sz, csz, bsz;
  unsigned char g;
  unsigned char e;
  sock_t *sk;
  struct file_s *next;
};
typedef struct file_s file_t;

struct scount_s 
{
  unsigned long libraries, songs, gigs;
};
typedef struct scount_s scount_t;

struct colortab_s 
{
  char *in;
  int pair, c;
};
typedef struct colortab_s colortab_t;


#define ICMP_ECHO 8
struct icmphdr 
{
  unsigned char type, code;
  unsigned short checksum;
  union
  {
    struct
    {
      unsigned short id, sequence;
    } echo;
    unsigned long gateway;
    struct
    {
      unsigned short blah, mtu;
    } frag;
  } un;
};



#define I_NAP_FUNC(x) int (x)(int s, char *str, char **tok, int num, WINDOW *win)

I_NAP_FUNC(sjoin);
I_NAP_FUNC(spart);
I_NAP_FUNC(stopic);
I_NAP_FUNC(ssay);
I_NAP_FUNC(snchan);
I_NAP_FUNC(sjchan);
I_NAP_FUNC(nothing);
I_NAP_FUNC(snotice);
I_NAP_FUNC(sscount);
I_NAP_FUNC(stell);
I_NAP_FUNC(suser);
I_NAP_FUNC(swhois);
I_NAP_FUNC(soff);
I_NAP_FUNC(sget);
I_NAP_FUNC(snget);
I_NAP_FUNC(sfreq);
I_NAP_FUNC(sry);
I_NAP_FUNC(ssf);
I_NAP_FUNC(smpart);
I_NAP_FUNC(suon);
I_NAP_FUNC(suoff);
I_NAP_FUNC(ssret);
I_NAP_FUNC(ssend);
I_NAP_FUNC(srbrowse);
I_NAP_FUNC(sdbrowse);
I_NAP_FUNC(sop);
I_NAP_FUNC(spchange);
I_NAP_FUNC(sbport);
I_NAP_FUNC(sannounce);
I_NAP_FUNC(sbanlist);
I_NAP_FUNC(scping);
I_NAP_FUNC(scpong);
I_NAP_FUNC(ssping);
I_NAP_FUNC(sredir);
I_NAP_FUNC(scycle);
I_NAP_FUNC(sclist);
I_NAP_FUNC(sclist2);
I_NAP_FUNC(snend);
I_NAP_FUNC(sblocklist);
I_NAP_FUNC(signorelist);
I_NAP_FUNC(signoreend);
I_NAP_FUNC(signoreadd);
I_NAP_FUNC(signoreremove);
I_NAP_FUNC(signoreunknown);
I_NAP_FUNC(signoreexists);
I_NAP_FUNC(signoreclear);
I_NAP_FUNC(signorefail);
I_NAP_FUNC(scbanlist);
I_NAP_FUNC(snerr);
I_NAP_FUNC(snadd);
I_NAP_FUNC(sme);


#define O_NAP_FUNC(x) int (x)(int s, char *str, char **tok, int num, WINDOW *win)

O_NAP_FUNC(ddebug);
O_NAP_FUNC(djoin);
O_NAP_FUNC(dpart);
O_NAP_FUNC(dquit);
O_NAP_FUNC(dtell);
O_NAP_FUNC(dwhois);
O_NAP_FUNC(dget);
O_NAP_FUNC(dpup);
O_NAP_FUNC(dpdown);
O_NAP_FUNC(dsearch);
O_NAP_FUNC(dkill);
O_NAP_FUNC(dban);
O_NAP_FUNC(dunban);
O_NAP_FUNC(ddatap);
O_NAP_FUNC(dtopic);
O_NAP_FUNC(dlevel);
O_NAP_FUNC(dg);
O_NAP_FUNC(dopsay);
O_NAP_FUNC(ddns);
O_NAP_FUNC(dannounce);
O_NAP_FUNC(pchans);
O_NAP_FUNC(dbanlist);
O_NAP_FUNC(dlspeed);
O_NAP_FUNC(ddup);
O_NAP_FUNC(ddown);
O_NAP_FUNC(dpsocks);
O_NAP_FUNC(dmuzzle);
O_NAP_FUNC(dunmuzzle);
O_NAP_FUNC(ddisconnect);
O_NAP_FUNC(dreload);
O_NAP_FUNC(dreconnect);
O_NAP_FUNC(dbrowse);
O_NAP_FUNC(dhelp);
O_NAP_FUNC(dping);
O_NAP_FUNC(duserpass);
O_NAP_FUNC(dreloadconf);
O_NAP_FUNC(dsver);
O_NAP_FUNC(dsetconf);
O_NAP_FUNC(dchanclear);
O_NAP_FUNC(dsetlevel);
O_NAP_FUNC(dme);
O_NAP_FUNC(dusers);
O_NAP_FUNC(dgusers);
O_NAP_FUNC(dclist);
O_NAP_FUNC(dclist2);
O_NAP_FUNC(dclear);
O_NAP_FUNC(dnews);
O_NAP_FUNC(dsraw);
O_NAP_FUNC(dquery);
O_NAP_FUNC(dcloak);
O_NAP_FUNC(dblocklist);
O_NAP_FUNC(dblock);
O_NAP_FUNC(dunblock);
O_NAP_FUNC(dwindow);
O_NAP_FUNC(dignore);
O_NAP_FUNC(dunignore);
O_NAP_FUNC(dignoreclear);
O_NAP_FUNC(dignorelist);
O_NAP_FUNC(dalias);
O_NAP_FUNC(dunalias);
O_NAP_FUNC(daliaslist);
O_NAP_FUNC(dhandler);
O_NAP_FUNC(dunhandler);
O_NAP_FUNC(dhandlerlist);
O_NAP_FUNC(dcbanlist);
O_NAP_FUNC(dcban);
O_NAP_FUNC(dcunban);
O_NAP_FUNC(dcbanclear);
O_NAP_FUNC(dkick);
O_NAP_FUNC(dloadalias);
O_NAP_FUNC(dsavealias);
O_NAP_FUNC(dclearalias);
O_NAP_FUNC(dloadhandler);
O_NAP_FUNC(dsavehandler);
O_NAP_FUNC(dclearhandler);
O_NAP_FUNC(dwstats);
O_NAP_FUNC(dnotify);
O_NAP_FUNC(dunnotify);
O_NAP_FUNC(dhotlist);
O_NAP_FUNC(dsay);
O_NAP_FUNC(dhup);
O_NAP_FUNC(dtquit);
O_NAP_FUNC(dabout);
O_NAP_FUNC(dirc);
O_NAP_FUNC(dkickall);
O_NAP_FUNC(deval);
O_NAP_FUNC(dset);
O_NAP_FUNC(dunset);
O_NAP_FUNC(dsaveconfig);
O_NAP_FUNC(dloadconfig);
O_NAP_FUNC(decho);
O_NAP_FUNC(dresults);
O_NAP_FUNC(dexec);
O_NAP_FUNC(dtimer);
O_NAP_FUNC(dif);
O_NAP_FUNC(ddone);
O_NAP_FUNC(dwhile);
O_NAP_FUNC(dinc);
O_NAP_FUNC(ddec);
O_NAP_FUNC(dbreak);
O_NAP_FUNC(dlastlog);
O_NAP_FUNC(drebuild);
O_NAP_FUNC(dchupload);
O_NAP_FUNC(dtlist);
O_NAP_FUNC(dnoprint);
O_NAP_FUNC(dstop);
O_NAP_FUNC(dserv);
O_NAP_FUNC(dserver);
O_NAP_FUNC(dupdate);



void upchan(chans_t *);
static int in_cksum(u_short *, int);
static void tvsub(register struct timeval *, register struct timeval *);
int icmpin(WINDOW *, sock_t *);
char **form_toks(char *, int *);
char **form_tokso(char *, int *);
int parsein(int, unsigned short, char *, WINDOW *);
char **fxv(char **, int, int *);
int parseout(int, char *, WINDOW *);
int parseoutn(int, char *, WINDOW *);
int gnum(unsigned char[], unsigned char);
char *cstr(char *, int);
char *cspstr(char **, int, int);
int fcnt(file_t *);
int fcntr(file_t *);
void dupload(char *, char *);
void ddownload(char *, char *);
int tlist(file_t *, char *, char *);
file_t *ffile(file_t *, char *, char *);
void adduser(chans_t *, char *, int, unsigned char);
void deluser(chans_t *, char *);
user_t *finduser(chans_t *, char *);

#endif
