/* Copyright (c) 2000  Kevin Sullivan <nite@gis.net>
 *
 * Please refer to the COPYRIGHT file for more information.
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <ncurses.h>

#include "defines.h"
#include "nap.h"
#include "exp.h"

#ifndef MCURSES
#include <ncurses.h>
#else 
#include "wind.h"
#endif


int initfserve(int port)
{
  struct sockaddr_in me;
  int s, on = 1;
  
  if (!port)
    return(1);
  
  me.sin_addr.s_addr = INADDR_ANY;
  me.sin_port = htons(port);
  me.sin_family = AF_INET;
  
  s = socket(AF_INET, SOCK_DGRAM, 0);
  if (s == -1)
    return(-1);
  
  setsockopt(s, SOL_SOCKET, SO_REUSEADDR, &on, sizeof(on));
  
  if (bind(s, (struct sockaddr *)&me, sizeof(me)) == -1)
    return(-1);
  
  addsock(s, "fserve", S_R, gconne);
  
  return(1);
}

int gconne(WINDOW *win, sock_t *m)
{
  int s = m->s;
  struct sockaddr_in frm;
  int frmlen = sizeof(frm);
  
  wp(win, "hello\n");
  wrefresh(win);
  
  getpeername(s, (struct sockaddr *)&frm, &frmlen);
  wp(win, "%s\n", inet_ntoa(frm.sin_addr));
  wrefresh(win);
  
  addsock(s, "conn", S_R, lsock);
  ssock(s, "\n");
  
  return(1);
}
