/*
 * Copyright 1993 Network Computing Devices, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and
 * its documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name Network Computing Devices, Inc. not be
 * used in advertising or publicity pertaining to distribution of this 
 * software without specific, written prior permission.
 * 
 * THIS SOFTWARE IS PROVIDED `AS-IS'.  NETWORK COMPUTING DEVICES, INC.,
 * DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT
 * LIMITATION ALL IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NONINFRINGEMENT.  IN NO EVENT SHALL NETWORK
 * COMPUTING DEVICES, INC., BE LIABLE FOR ANY DAMAGES WHATSOEVER, INCLUDING
 * SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES, INCLUDING LOSS OF USE, DATA,
 * OR PROFITS, EVEN IF ADVISED OF THE POSSIBILITY THEREOF, AND REGARDLESS OF
 * WHETHER IN AN ACTION IN CONTRACT, TORT OR NEGLIGENCE, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 * 
 * $NCDId: @(#)osinit.c,v 1.3 1994/05/27 03:10:48 greg Exp $
 */
/***********************************************************
Some portions derived from:

Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/
#include "NasConfig.h"

#include <audio/audio.h>
#include <audio/Aproto.h>
#include "os.h"
#include "osdep.h"
#undef NULL
#include <stdio.h>
#include <audio/Aos.h>

#ifndef PATH_MAX
#ifdef MAXPATHLEN
#define PATH_MAX MAXPATHLEN
#else
#define PATH_MAX 1024
#endif
#endif

#if !defined(SYSV) && !defined(AMOEBA) && !defined(_MINIX)
#include <sys/resource.h>
#endif

#ifndef ADMPATH
#define ADMPATH NAS_AUDIOMSGFILE
#endif

extern char *display;
#ifdef RLIMIT_DATA
int limitDataSpace = -1;
#endif
#ifdef RLIMIT_STACK
int limitStackSpace = -1;
#endif
#ifdef RLIMIT_NOFILE
int limitNoFile = -1;
#endif

void OsInit(void)
{
#ifndef AMOEBA
    static Bool been_here = FALSE;
    char fname[PATH_MAX];

#ifdef macII
    set42sig();
#endif

    if (!been_here) {
#if !defined(SCO) && !defined(__386BSD__)
        fclose(stdin);
        fclose(stdout);
#endif
        /* hack test to decide where to log errors */
        if (write(2, fname, 0)) {
            FILE *err;
            sprintf(fname, ADMPATH, display);
            /*
             * uses stdio to avoid os dependencies here,
             * a real os would use
             *  open (fname, O_WRONLY|O_APPEND|O_CREAT, 0666)
             */
            if (!(err = fopen(fname, "a+")))
                err = fopen("/dev/null", "w");
            if (err && (fileno(err) != 2)) {
                dup2(fileno(err), 2);
                fclose(err);
            }
#if defined(SYSV) || defined(SVR4) || defined(AMOEBA) || defined(_MINIX)
            {
                static char buf[BUFSIZ];
                setvbuf(stderr, buf, _IOLBF, BUFSIZ);
            }
#else
# if !defined(__CYGWIN__)
            setlinebuf(stderr);
# endif
#endif
        }
#ifndef X_NOT_POSIX
        if (getpgrp() == 0)
            setpgid(0, 0);
#else
#ifndef SYSV
        if (getpgrp(0) == 0)
            setpgrp(0, getpid());
#endif
#endif

#ifdef RLIMIT_DATA
        if (limitDataSpace >= 0) {
            struct rlimit rlim;

            if (!getrlimit(RLIMIT_DATA, &rlim)) {
                if ((limitDataSpace > 0)
                    && (limitDataSpace < rlim.rlim_max))
                    rlim.rlim_cur = limitDataSpace;
                else
                    rlim.rlim_cur = rlim.rlim_max;
                (void) setrlimit(RLIMIT_DATA, &rlim);
            }
        }
#endif
#ifdef RLIMIT_STACK
        if (limitStackSpace >= 0) {
            struct rlimit rlim;

            if (!getrlimit(RLIMIT_STACK, &rlim)) {
                if ((limitStackSpace > 0)
                    && (limitStackSpace < rlim.rlim_max))
                    rlim.rlim_cur = limitStackSpace;
                else
                    rlim.rlim_cur = rlim.rlim_max;
                (void) setrlimit(RLIMIT_STACK, &rlim);
            }
        }
#endif
#ifdef RLIMIT_NOFILE
        if (limitNoFile >= 0) {
            struct rlimit rlim;

            if (!getrlimit(RLIMIT_NOFILE, &rlim)) {
                if ((limitNoFile > 0) && (limitNoFile < rlim.rlim_max))
                    rlim.rlim_cur = limitNoFile;
                else
                    rlim.rlim_cur = rlim.rlim_max;
                if (rlim.rlim_cur > MAXSOCKS)
                    rlim.rlim_cur = MAXSOCKS;
                (void) setrlimit(RLIMIT_NOFILE, &rlim);
            }
        }
#endif
        been_here = TRUE;
#endif /* AMOEBA */
    }
    OsInitAllocator();
}
