/*
 * Get canonical name of the host
 */

#ifndef lint
char rcsid[] = "@(#)netname.c,v 1.12 1999/09/15 03:23:24 kim Exp";
#endif

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/utsname.h>
#include <sys/param.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/types.h>
#ifdef ultrix
#include <sys/svcinfo.h>
#endif

void usage(char *me)
{
  fprintf(stderr, "Usage: %s [-d] [-v] [host]\n", me);
  exit(1);
}

int main(int argc, char **argv)
{
  struct hostent *hp;
  char *host = NULL;
  struct utsname name;
  int c, d = 0;
#ifdef ultrix
  struct svcinfo *svcinfo;
#endif
  extern int optind;

  while ((c = getopt(argc, argv, "dv")) != EOF)
    switch (c) {
    case 'd':
      d = 1;
      break;
    case 'v':
      fprintf(stderr,
	      "%s version 1.7 (Copyright (c) 1995-1999 Kimmo Suominen)\n%s\n",
	      argv[0], rcsid);
      /* fall through */
    default:
      usage(argv[0]);
    }

  switch (argc - optind) {
  case 0:
    if (uname(&name) == -1) {
      fprintf(stderr, "%s: cannot get uname information\n", argv[0]);
      exit(2);
    }
    host = name.nodename;
    break;
  case 1:
    host = argv[optind];
    break;
  default:
    usage(argv[0]);
  }

#ifdef ultrix
  /* On ultrix, force use of the DNS resolver instead of the hosts file */
  if ((svcinfo = getsvc()) != NULL) {
    if (svcinfo->svcpath[SVC_HOSTS][0] == SVC_LOCAL) {
      int i;

      for (i = 0; i < SVC_PATHSIZE - 1; i++)
        svcinfo->svcpath[SVC_HOSTS][i] = svcinfo->svcpath[SVC_HOSTS][i + 1];
    }
  }
#endif
  if ((hp = gethostbyname(host)) == NULL) {
    fprintf(stderr, "%s: cannot resolve %s\n", argv[0], host);
    exit(1);
  }

  if (d && (host = strchr(hp->h_name, '.')) != NULL)
    host++;
  else
    host = hp->h_name;
  printf("%s\n", host);
  return(0);
}
