/* newsfetch.h: header file for newsfetch program */
#ifndef _NEWSFETCH_H
#define _NEWSFETCH_H

#define NEWSFETCHRC ".newsfetchrc"
#define NEWSFETCHLOCK ".newsfetchlock"
#define NEWSFETCH_HEADER_INCL "Newsfetch"
#define COMMAND_GROUP_REPLACE "%s"
#define PROCMAIL_COMMAND "procmail " /*space is important*/
#define PROCMAIL_TMPL ".newsfetchfilter"
#define PROCMAIL_RC ".newsfetchproc"
#define READ_TIMEOUT 600
#define NAME "newsfetch"

/*
 * public functions
 */

/* newsfetch.c */
void exit_now(int exit_status);

/* getopt.c */
int getopt(int argc, char *const argv[], const char *opts);

/* net.c */
int connect_server(char *server_name, int port, int exit_flag);
void create_fd(int socketid, FILE ** sfp); 

/* nntp.c */
int set_reader_mode(void);
int get_next_group(void);
int check_group(void);
int fetch_group(void);
void get_group_list(void);
void send_quit(void);
void fill_tmpfile(void);

/* opt.c */
int get_commandline(int argc, char *argv[], char *dirname, char *rcname,
	      int *cleanup, int *wait_after_articles, int *wait_for_time,
		    int *command_flag, char *execute_command,
		    int *pipe_flag, char *pipe_command, int *only_list,
		    int *procmailrc, int *timeout);
void opt_help(char *prog_name);

/* util.c */
void gethome(char *homedir);
void default_rcfiles(char *homedir, char *rcfile, char *copycmd);
void generate_procmailrc(char *homedir, char *rcfile, 
				char *dirname, char *pipe_command);
int create_directory(char *);
void mkcmd(char *src, char *search, char *replace, char *dest);

#endif /* _NEWSFETCH_H */



