#!/bin/sh

NINJADIR="$HOME/.ninja"

[ -d "$NINJADIR" ] || (echo "No ninja dir!" && exit 1)

#
# check for ninja directory files..
#
function chkfile()
{
  echo -n "Checking for NINJADIR/$2 .."
  if [ ! -f "$NINJADIR/$2" -a -f "$NINJADIR/$1" ]; then
     cp -f "$NINJADIR/$1" "$NINJADIR/$2"
     echo "NOTE: $NINJADIR/$1 is no longer used by ninja-1.5.5pre2 and above.. you can remove it if you don't plan on using any older versions..."
  else
     echo "..ok"
  fi
}

#
# check for home directory files..
#
function chkfile2()
{
  echo -n "Checking for HOME/$2 .."
  if [ ! -f "$NINJADIR/$2" -a -f "$HOME/$1" ]; then
     cp -f "$HOME/$1" "$NINJADIR/$2"
     echo "NOTE: $HOME/$1 is no longer used by ninja-1.5.5pre2 and above.. you can remove it if you don't plan on using any older versions..."
  else
     echo "..ok"
  fi
}


chkfile "ninja.save" "save"
chkfile "ninja.away" "away"
chkfile "ninja.passwd" "friends"
chkfile "ninja.shit" "enemies"
chkfile "ninja.history" "history"
chkfile "ninja.chankeys" "ckeys"

chkfile2 ".ircrc" "rc"
chkfile2 ".ircquick" "quick"

echo "done migrating."
exit 0