/* $Id: ntypes.h,v 1.1.1.1 1998/08/02 20:30:34 proff Exp $
 * $Copyright$
 */

#ifndef NTYPES_H
#define NTYPES_H

#include <sys/types.h>

#ifdef HAVE_SYS_PARAM_H
#  include <sys/param.h>
#endif

#define STDIN	0
#define STDOUT	1
#define STDERR	2

#define bool	int
#define TRUE	1
#define FALSE	0
#define ABORT	-1

typedef
#if	SIZEOF_CHAR	== 1
	char
#elif	SIZEOF_SHORT	== 1
	short 
#elif	SIZEOF_INT	== 1
        int
#elif	SIZEOF_LONG	== 1
	long
#elif	SIZEOF_LONG_INT == 1
        long int
#elif	SIZEOF_LONG_LONG== 1
	long long
#else
#  error no 8 bit type
#endif
		n_8;

typedef unsigned
#if	SIZEOF_CHAR	== 1
	char
#elif	SIZEOF_SHORT	== 1
	short 
#elif	SIZEOF_INT	== 1
        int
#elif	SIZEOF_LONG	== 1
	long
#elif	SIZEOF_LONG_INT == 1
        long int
#elif	SIZEOF_LONG_LONG== 1
	long long
#else
#  error no 8 bit type
#endif
		n_u8;

typedef
#if	SIZEOF_SHORT	== 2
	short
#elif	SIZEOF_INT	== 2
        int
#elif	SIZEOF_LONG	== 2
	long
#elif	SIZEOF_LONG_INT == 2
        long int
#elif	SIZEOF_LONG_LONG== 2
	long long
#else
#  error no 16 bit type
#endif
		n_16;

typedef unsigned
#if	SIZEOF_SHORT	== 2
	short
#elif	SIZEOF_INT	== 2
        int
#elif	SIZEOF_LONG	== 2
	long
#elif	SIZEOF_LONG_INT == 2
        long int
#elif	SIZEOF_LONG_LONG== 2
	long long
#else
#  error no 16 bit type
#endif
		n_u16;

typedef
#if	SIZEOF_SHORT	== 4
	short
#elif	SIZEOF_INT	== 4
        int
#elif	SIZEOF_LONG	== 4
	long
#elif	SIZEOF_LONG_INT == 4
        long int
#elif	SIZEOF_LONG_LONG== 4
	long long
#else
#  error no 32 bit type
#endif
		n_32;
typedef unsigned
#if	SIZEOF_SHORT	== 4
	short
#elif	SIZEOF_INT	== 4
        int
#elif	SIZEOF_LONG	== 4
	long
#elif	SIZEOF_LONG_INT == 4
        long int
#elif	SIZEOF_LONG_LONG== 4
	long long
#else
#  error no 32 bit type
#endif
		n_u32;

typedef
#if	SIZEOF_INT64_T	== 8
	int64_t
#elif	SIZEOF_QUAD_T	== 8
	quad_t
#elif	SIZEOF_INT	== 8
        int
#elif	SIZEOF_LONG	== 8
	long
#elif	SIZEOF_LONG_INT == 8
        long int
#elif	SIZEOF_LONG_LONG== 8
	long long
#else
#  warning no 64 bit type
#  define HAVE_BIG64
	n_32
#endif
		n_64;

typedef
#if	SIZEOF_U_INT64_T == 8
	u_int64_t
#elif	SIZEOF_UINT64_T == 8 /* hpux */
	uint64_t
#elif	SIZEOF_U_QUAD_T	== 8
	u_quad_t
#elif	SIZEOF_UQUAD_T	== 8
	uquad_t
#elif	SIZEOF_INT	== 8
        unsigned int
#elif	SIZEOF_LONG	== 8
	unsigned long
#elif	SIZEOF_LONG_INT == 8
        unsigned long int
#elif	SIZEOF_LONG_LONG== 8
	unsigned long long
#else
#  warning no unsigned 64 bit type
	n_u32
#endif
		n_u64;

typedef n_64 big_t;


/*
 * printf format character for a big_t
 */
#define BF "%U"

/*
 * macro to cast a big_t into the above
 */
#define BFT(x) ((int)(x))

/*
 * possibly defined in <sys/param.h>
 */

#ifndef MIN
#  define MIN(x,y) (((x)<(y))? (x): (y))
#endif
#ifndef MAX
#  define MAX(x,y) (((x)>(y))? (x): (y))
#endif

#define EITHER(x,y) ((x)? (x): (y))

#ifndef NULL
#  define NULL ((void *)0)
#endif

#endif /* NTYPES_H */
