/* $Id: authinfo.h,v 1.1 1999/12/18 18:08:30 proff Exp $
 * $Copyright$
 */

#ifndef AUTHENTICATE_H
#define AUTHENTICATE_H

/*
 * authenticators.  we define an interface between nntpcache
 * "AUTHINFO" handling, and random authentication routines
 * via a structure of pointers to functions: struct authenticator
 */

typedef struct authenticator {
	int	(*authinfo_user)(char *);	/* MUST fill in `authinfo_user' */
	int	(*authinfo_pass)(char *);
#ifdef notyet
	int	(*authinfo_sasl)(char *);	/* not used yet */
#endif
} authenticator;

/*
 * known authentication methods
 */
#define	AUTHINFO_UNKNOWN	-1
#define	AUTHINFO_NONE		0
#define	AUTHINFO_USERPASS	1
#define	AUTHINFO_SASL		2	/* unsupported */

/*
 * structure for a particular `access' config line
 */
struct authinfo {
	int		type;		/* see above */
	authenticator	*authenticator;	/* see above */
};

#include "authinfo.ext"

#endif /* AUTHENTICATE_H */
