/* $Id: authinfo_radius.c,v 1.1 1999/12/18 18:08:30 proff Exp $
 * $Copyright$
 */

#include "nglobal.h"

#ifdef AUTHINFO_RADIUS

#include "acc.h"
#include "reg.h"

#include "authinfo.h"
#include "authinfo_radius.h"

#if defined(HAVE_RAD_AUTH_OPEN) || defined(HAVE_RAD_OPEN)
#include <radlib.h>
#if !defined(HAVE_RAD_AUTH_OPEN)
#define rad_auth_open rad_open	/* old freebsd */
#endif
#else
#include "../libradius/radlib.h"
#endif

/*
 * passwd authenticator.
 */

EXPORT authenticator radius_authenticator = {
	authinfo_got_user,
	radius_got_pass,
#ifdef notyet
	radius_got_sasl,
#endif
};

static struct rad_handle *radh;

/*
 * here we initialise our radius servers, called from startup.
 */
EXPORT int authinfo_radius_init(void)
{
	int rv = 0;

	if (radh)
		rad_close(radh);

	radh = rad_auth_open();
	if (radh == NULL) {
		logen(("rad_auth_open failed"));
		return (0);
	}

	if (con->radiusConfig && !con->radiusConfig) {
		rv = 1;
		if (rad_config(radh, con->radiusConfig) < 0) {
			logen(("rad_config failed"));
			return (0);
		}
	}

	if (con->radiusAuthServer && *con->radiusAuthServer) {
		rv = 1;
		if (!con->radiusAuthSecret || !*con->radiusAuthSecret) {
			logen(("radiusServer configured but no radiusSecret"));
			return (0);
		}
		if (!con->radiusAuthPort)
			con->radiusAuthPort = 1645;
		if (!con->radiusAuthTimeout)
			con->radiusAuthTimeout = 3;
		if (!con->radiusAuthRetries)
			con->radiusAuthRetries = 3;

		if (rad_add_server(radh, con->radiusAuthServer, con->radiusAuthPort, con->radiusAuthSecret, con->radiusAuthTimeout, con->radiusAuthRetries) < 0) {
			logen(("rad_add_server failed"));
			return (0);
		}
	}
	if (rv == 0)
		logen(("no radius or server configuration"));	/* XXX? what about default /etc/radius.conf? */
	return (rv);
}

/*
 * here are the "user", "pass" and (unsupported) "sasl" routines for a radius
 * authenticator; note that these are EXPORT so we get prototypes for the
 * "radius_authenticator" above, which hooks us into authinfo.c ...
 */

/* we use authinfo_got_user() */

EXPORT int radius_got_pass(char *pass)
{
	int rv = 0;

	if (authinfo_user == NULL) {
		emitf("%d USER required\r\n", NNTP_AUTH_REJECT_VAL);
		return FALSE;
	}
	if (pass && *pass) {

		/*
		 * ok.  we fill create an access request request, fill in
		 * the details: login type, username, password, IP address.
		 */
		if (rad_create_request(radh, RAD_ACCESS_REQUEST) < 0) {
			logen(("rad_create_request failed: %s", rad_strerror(radh)));
			goto request_made;
		}

		if (rad_put_int(radh, RAD_SERVICE_TYPE, RAD_AUTHENTICATE_ONLY) < 0) {
			logen(("rad_put_int service type failed: %s", rad_strerror(radh)));
			goto request_made;
		}

		if (rad_put_string(radh, RAD_USER_NAME, authinfo_user) < 0) {
			logen(("rad_put_int username failed: %s", rad_strerror(radh)));
			goto request_made;
		}

		if (rad_put_string(radh, RAD_USER_PASSWORD, pass) < 0) {
			logen(("rad_put_int password failed: %s", rad_strerror(radh)));
			goto request_made;
		}

		if (rad_put_addr(radh, RAD_NAS_IP_ADDRESS, ClientRemoteAddr.sin_addr) < 0) {
			logen(("rad_put_int IP address failed: %s", rad_strerror(radh)));
			goto request_made;
		}

		/*
		 * lets send the request and see if they pass.
		 */
		switch (rad_send_request(radh)) {
		case RAD_ACCESS_ACCEPT:
			rv = 1;
			break;
		case RAD_ACCESS_CHALLENGE:
			logen(("radius: access challenge received, failing"));
			/* FALLTHROUGH */
		default:
			logen(("radius authentication failed: %s", rad_strerror(radh)));
		}
	}
	
request_made:
	if (rv != 0) {
		emitf("%d Authentication accepted\r\n", NNTP_AUTH_OK_VAL);
		return TRUE;
	}
	emitf("%d Authentication rejected\r\n", NNTP_AUTH_REJECT_VAL);
	return FALSE;
}

#ifdef notyet
EXPORT int radius_got_sasl(char *val)
{

}
#endif

#endif /* AUTHINFO_RADIUS */
