/* $Id: newgroups.c,v 1.5 2002/03/26 11:18:35 proff Exp $
 * $Copyright$
 */

#include "nglobal.h"

#include "group.h"
#include "nlist.h"

#include "newgroups.h"

static int c2i(char *s)
{
	if (!isdigit(s[0]) || !isdigit(s[1]))
		return -1;
	return (s[0]-'0')*10+(s[1]-'0');
}

EXPORT bool CMDnewgroups(char *args)
{
	struct newsgroup *n;
	time_t tim;
	time_t now;
	struct tm tm;
	char d[11];
	char gmt[4]="";
	char dist[128]="";
	int i;
	int t[5];
	char arg1[9];
	int len;
	int yr;
	memset(d, 0, sizeof d);
	if (sscanf(args, "%*s %8s %6s %3s <%127s>", arg1, d+4, gmt, dist)<2)
	{
bad:
		emitrn("501 [yy]yymmdd hhmmss [\"GMT\"] [<distributions>]");
		return FALSE;
	}
	len = strlen(arg1);
	if (len < 5 || atoi(arg1) == 0) /* < 5, because some news readers send single digit years. i.e 0 */
		goto bad;
	strncpy(d, arg1+len-4, 4);
	for (i=0; i<5; i++)
		if ((t[i]=c2i(d+2*i))==-1)
			goto bad;
	/* deal with y2k bugged readers */
	arg1[len-4] = '\0';
	yr = atoi(arg1);
	if (yr>=19100)
	    yr-=19000;
	if (yr>=1900)
		yr-=1900;
	if (yr <70)
		yr += 100;
	memset(&tm, 0, sizeof tm);
	tm.tm_year = yr;
	tm.tm_mon = t[0]-1;
	tm.tm_mday = t[1];
	tm.tm_hour = t[2];
	tm.tm_min = t[3];
	tm.tm_sec = t[4];
	if ((tim=mktime(&tm))==-1)
		goto bad;
	emitrn (NNTP_NEWGROUPS_FOLLOWS);
	now = time(NULL);
	for (n=Ni->newsgroup_head; n; n=n->next)
	{
		newsgroupLockRead(n);
		if (!n->moderation ||
		    n->creation_time < tim ||
		    n->creation_time > now ||
		    (con->groupSecurity && !authGroup(n->group, FALSE)))
		    	goto cont;
		if (*dist)
		{
			char *p;
			for (p=dist;;)
			{
				char *p2=strchr(p, ',');
				if (strnCaseEq(n->group, p, p2? p2-p: strlen(p)))
					goto good;
				if (!p2)
					break;
				p=p2+1;
			}
			goto cont;
		}
	good:
		emitf ("%s %d %d %c\r\n", n->group, getHi(n), getLo(n), n->moderation);
	cont:
		newsgroupUnlockRead(n);
	}
	emitrn (".");
	return TRUE;
}
