/* $Id: stats.h,v 1.2 1999/12/31 03:50:06 proff Exp $
 * $Copyright$
 */

#ifndef STATS_H
#define STATS_H

struct nocem_stats
{
    big_t art_good;
    big_t art_skip;
    big_t art_fail;
    big_t pgp_good;
    big_t pgp_fail;
    big_t msgid_good;
    big_t msgid_dup;
    big_t msgid_fail;
    big_t bytes_from;
    time_t last_scan;
    int art_hi;
};

struct task_stats
{
    big_t cpu_system;
    big_t cpu_user;
    big_t elapsed;
    big_t invocations;
};

struct cache_stats
{
    big_t requests;
    big_t requests_good;
    big_t requests_failed;
    big_t filter_blocked;
    big_t auth_blocked;
    big_t nocem_blocked;
    big_t serverToBytes;
    big_t serverFromBytes;
    big_t clientToBytes;
    big_t clientFromBytes;
    big_t by_msgid;
    big_t by_artnum;
};    

struct list_stats
{
    big_t entries;
    big_t len;
    struct cache_stats cache_stats;
};

struct stats
{
#define STATS_VERSION 14 /* increment each time this struct changes ! */
	int version; 
	int invocations;
	time_t statsStarted;
	time_t masterStarted;
	int clientsActive;
        int task_high;
	big_t clientConnects;
        big_t clientConnectsFailed;
	big_t IPCfromChild;
	big_t IPCfromChildBytes;
	big_t IPCtoChild;
	big_t IPCtoChildBytes;

   	struct list_stats list_stats[l_last];
        struct task_stats task_stats[nc_last];
        struct nocem_stats nocem_stats[MAX_NOCEM];
        struct cache_stats cache_stats[c_none];
    
        big_t msgidFromCache;
        big_t msgidFromCacheBytes;
	big_t serverConnects;
	big_t serverConnectsFailed;
	big_t client_elapsed;
	big_t historyStores;
        big_t historyStoresBytes;
	big_t historyFetches;
	int historySize;
        big_t article_unlinked;
	big_t groupsCached;
	big_t crossposts;
	big_t crosspostsBytes;
	big_t posts;
	big_t postsBytes;
	big_t postsCross;
	big_t postsFailed;
	big_t serverFromBytes;
	big_t serverToBytes;
	big_t clientFromBytes;
	big_t clientToBytes;
	big_t articlesExpired;
	big_t groupsExpired;
	big_t xoversExpired;
};

#include "stats.ext"

#endif /* STATS_H */
