/* options.h */

/*
    NUT nutrition software 
    Copyright (C) 1996-2010 by Jim Jozwiak.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef OPTIONS_H
#define OPTIONS_H

#include "food.h"
#include "meal.h"

struct opt
 {
 int delopt;
 int defanal;
 int defanalanal;
 int defanalrec;
 int screen;
 int custom;
 float pcprotein;
 float pccarb;
 float pcsatfat;
 float carbcalpergm;
 float protcalpergm;
 float fatcalpergm;
 float fattyacidfactor;
 float n6hufa;
 float alafactor;
 float epadhamax;
 float lastwlw;
 float lastwlbfp;
 float lastwldate;
 float fattarget;
 float leantarget;
 int next_recipe;
 int locknuts[NUTRIENT_COUNT];
 float abnuts[NUTRIENT_COUNT];
 int mealsperday;
 char grams;
 char autocal;
 struct meal *temp_meal_root;
 };

#define ALA_FACTOR 7

#define DELOPT        1000 
#define DEFANAL       1001
#define SCREEN        1002
#define CUSTOM        1003
#define PCPROTEIN     1004
#define PCCARB        1005
#define PCSATFAT      1006
#define NEXT_RECIPE   1008
#define MEALSPERDAY   1009
#define GRAMS         1010 
#define AUTOCAL       1011
#define PROTCALPERGM  1012
#define CARBCALPERGM  1013
#define FATCALPERGM   1014
#define FATTYACIDFACTOR 1015
#define N6HUFA        1016
#define ALAFACTOR     1017
#define EPADHAMAX     1018
#define DEFANALANAL   1019
#define DEFANALREC    1020
#define LASTWLW       1021
#define LASTWLBFP     1022
#define LASTWLDATE    1023
#define FATTARGET     1024
#define LEANTARGET    1025

#define OPT_CHO_NONFIB 2000
#define OPT_LA         2001
#define OPT_AA         2002
#define OPT_ALA        2003
#define OPT_EPA        2004
#define OPT_DHA        2005
#define OPT_OMEGA6     2006
#define OPT_OMEGA3     2007
#define OPT_VITE       2008

extern struct opt options;

#ifdef __cplusplus
extern "C" {
#endif

void initialize_options(void);
void personal_cal(void);
void efa_options(void);
void efa_method(void);
void protein_percent(void);
void carb_percent(void);
void satfat_percent(void);
void protein_absolute(void);
void carb_absolute(void);
void fiber_absolute(void);
void auto_cal(float *, int);
void auto_del(void);
void screen(void);
void screen_previous(void);
void get_cals(float *);
void new_nut_levels(void);
void restore_defaults(int);
void efa_dynamics();
void weight_log();

#ifdef __cplusplus
} /* closing brace for extern "C" */
#endif
 
#endif
