#include "oak.h"
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <string.h>
#include <sys/wait.h>

/* returns an action whose funciton is looked up from "name" and which
 * has the arguments argv and arugment count argc
 *
 * ******* NEED TO IMPLEMENT THIS **************
 */
oak_action *oak_action_create(char *name, int argc, char **argv)
{
  return(NULL);
}

/* returns an action whose function is looked up fromn "name" and
 * which has the arguemnts parsed from args, being space seperated
 */
oak_action *oak_action_create_from_argstring(char *name, char *args)
{
  oak_action *out;

  out=malloc(sizeof(oak_action));
  out->name=strdup(name);
  out->argv=argstring_to_argv(args, &(out->argc));

  out->haslimits=0;
  
  return(out);
}

void oak_action_set_limits(oak_action *act, int lines, int linelen, int numhosts, int hostents)
{
  act->haslimits=1;

  act->limit_lines=lines;
  act->limit_linelen=linelen;
  act->limit_numhosts=numhosts;
  act->limit_hostents=hostents;
}

/* Execute the action.  we probably should have compalined in
 * readconfig if we don't know the argv[0] action argc < 1.  Oh well,
 * this is supposed to be a quick hack
 */
void oak_action_execute(oak_action *act, oak_queue *q)
{

  FILE *file;
  char command[1024];
  char *msg;
  int i;

  if (!act) return;

  if (act->argc<1) return;

  if (!oak_global_is_debug(&g)) {
    i=fork();  
    if (i) {
      wait3(NULL, WNOHANG, NULL);
      return;
    }
  }

  if (!strcmp(act->argv[0], "zwrite")) {
    if (oak_global_is_debug(&g)) printf("DEBUG: doing zwrite\n");

    putenv("KRBTKFILE=/tmp/tkt_oak");
    putenv("KRB5CCNAME=/tmp/tkt5_oak");
    system("/usr/athena/bin/klist -s > /dev/null 2> /dev/null || /usr/athena/bin/kinit -l 5m -k");
    if (!strcmp(act->argv[3], "*")) {
      sprintf(command, "/usr/athena/bin/zwrite -q -n -c %s -i %s >/dev/null 2>/dev/null", act->argv[1], act->argv[2]);
    } else {
      sprintf(command, "/usr/athena/bin/zwrite -q -n -c %s -i %s %s >/dev/null 2>/dev/null", act->argv[1], act->argv[2], act->argv[3]);
    }

    file=popen(command, "w");
    msg=NULL;
    if (act->haslimits) {
      msg=oak_queue_to_string(q, act->limit_lines, act->limit_linelen, act->limit_numhosts, act->limit_hostents);
    } else {
      msg=oak_queue_to_string(q, 50, 100, 0, 0);
    }
    if (msg) {
      fputs(msg, file);
      free(msg);
    }
    pclose(file);

  } else if (!strcmp(act->argv[0], "mail")) {
    char command[1024];
    char subject[1024];
    int i;
    char *ptr;

    sprintf(command, "%s -t", SENDMAIL);
    if (oak_global_is_debug(&g)) printf("DEBUG: sending mail message\n");

    /* if the subject arg starts with a quote, then grab up everything until the next quote */
    strcpy(subject, "");
    if (act->argv[3][0]=='"' || act->argv[3][0]=='\'') {
      strcat(subject, act->argv[3]+1);
      strcat(subject, " ");
      for (i=4; i<act->argc; i++) {
	strcat(subject, act->argv[i]);
	strcat(subject, " ");
      }
      subject[strlen(subject)-1]='\0'; /* nuke the final space we appeneded */
      ptr=strchr(subject, act->argv[3][0]); /* find the next quote */
      if (ptr) {
	subject[ptr-subject]='\0';
      } else {
	/* it didn't end, so we'll just take what we got */
      }
    } else {
      strcpy(subject, act->argv[3]);
    }
    
    file=popen(command, "w");
    fprintf(file, "To: %s\n", act->argv[1]);
    fprintf(file, "From: %s\n", act->argv[2]);
    fprintf(file, "Subject: %s\n\n", subject);
    if (act->haslimits) {
      msg=oak_queue_to_string(q, act->limit_lines, act->limit_linelen, act->limit_numhosts, act->limit_hostents);
    } else {
      msg=oak_queue_to_string(q, 0, 0, 0, 0);
    }
    if (msg) {
      fputs(msg, file);
      free(msg);
    }
    pclose(file);
  } else if (!strcmp(act->argv[0], "exec")) {
    int i;
    
    if (oak_global_is_debug(&g)) printf("DEBUG: going to exec command\n");

    strcpy(command, "");
    for (i=0; i<act->argc-1; i++) {
      strcat(command, act->argv[i+1]);
      strcat(command, " ");
    }

    if (oak_global_is_debug(&g)) printf("DEBUG: command is %s\n", command);
    file=popen(command, "w");

    msg=NULL;
    if (act->haslimits) {
      msg=oak_queue_to_string(q, act->limit_lines, act->limit_linelen, act->limit_numhosts, act->limit_hostents);
    } else {
      msg=oak_queue_to_string(q, 0, 0, 0, 0);
    }
    if (msg) {
      fputs(msg, file);
      free(msg);
    }
    pclose(file);
  } else {
    /* some kind of warning? */
  }
  if (!oak_global_is_debug(&g)) {
    exit(0);
  }
}

char *oak_action_get_name(oak_action *act)
{
  return(act->name);
}
