#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <regex.h>
#include <sys/types.h>
#include <time.h>
#include "oak.h"

oak_matchline *oak_matchline_create(char *regex, char *queuenames)
{
  oak_matchline *out;
  int ret;
  char buff[LINE];
  char *ptr, *ptr2;
  
  out=malloc(sizeof(oak_matchline));
  ret=regcomp(&(out->regex), regex, REG_EXTENDED);
  if (ret) {
    regerror(ret, NULL, buff, LINE);
    fprintf(stderr, buff);
    fprintf(stderr, "\n");
    exit(1);
  }
  oak_list_create(&(out->ql));
  
  /* do the queues here */
  if (queuenames) {
    printf("%s\n", queuenames);
    ptr=strdup(queuenames);
    ptr2=strtok(ptr, " \r\n");
    if (oak_global_is_debug(&g)) printf("DEBUG: added queue '%s' to matchline\n", ptr2);
    oak_list_append_element(&(out->ql), oak_queuelist_get_queue_by_name(oak_global_get_queuelist(&g), ptr2));
    while ((ptr2=strtok(NULL, " \r\n"))!=NULL) {
      if (oak_global_is_debug(&g)) printf("DEBUG: added queue '%s' to matchline\n", ptr2);
      oak_list_append_element(&(out->ql), oak_queuelist_get_queue_by_name(oak_global_get_queuelist(&g), ptr2));
    }
  }

  oak_list_create(&(out->locked_queuelist));
  oak_list_create(&(out->lock_times));

  return(out);
}

int oak_matchline_set_queuelist_from_string(oak_matchline *m, char *queuenames)
{
  char *ptr, *ptr2;
  oak_queue *q;

  oak_list_create(&(m->ql));

  ptr=strdup(queuenames);
  ptr2=strtok(ptr, " \r\n");
  q=oak_queuelist_get_queue_by_name(oak_global_get_queuelist(&g), ptr2);
  if (q==NULL) return(-1);

  if (oak_global_is_debug(&g)) printf("DEBUG: adding queue '%s' to matchline\n", ptr2);
  oak_list_append_element(&(m->ql), q);
  while ((ptr2=strtok(NULL, " \r\n"))!=NULL) {
    q=oak_queuelist_get_queue_by_name(oak_global_get_queuelist(&g), ptr2);
    if (q==NULL) return(-1);
    
    if (oak_global_is_debug(&g)) printf("DEBUG: adding queue '%s' to matchline\n", ptr2);
    oak_list_append_element(&(m->ql), q);
  }
  return(0);
}

/* If the 'message' part of instr syslog line matches the regex then
 * return 1, otherwise return 0.  The matched string will be returned
 * in out except that anything in parens in the regex will be replaced
 * with ___
 */
int oak_matchline_string_matches(oak_matchline *m, char *instr, char *out)
{
  int ret;
  regmatch_t pmatch[15];
  char *tmpstr, *foostr, *replacestr;

  tmpstr=oak_text_get_line_from_log(instr);
  if (tmpstr==NULL) return(0);
  tmpstr=realloc(tmpstr, strlen(tmpstr)+200);
  foostr=malloc(strlen(tmpstr)+100);

  replacestr=oak_global_get_replacestr(&g);
  
  /* replace pids if we're supposed to */
  if (oak_global_is_nukepid(&g)) {

    /* first nuke any solaris 8 junk */
    ret=regexec(oak_global_get_regex_soljunk(&g), tmpstr, 15, pmatch, 0);
    if (!ret) {
      oak_text_replace_string_sections(tmpstr, pmatch, foostr, "");
      strcpy(tmpstr, foostr);
    }

    /* normal style */
    ret=regexec(oak_global_get_regex_pid(&g), tmpstr, 15, pmatch, 0);
    if (!ret) {
      oak_text_replace_string_sections(tmpstr, pmatch, foostr, replacestr);
      strcpy(tmpstr, foostr);
    }
  }

  /* do cisco pids too */
  if (oak_global_is_nukeciscoid(&g)) {
    ret=regexec(oak_global_get_regex_ciscopid(&g), tmpstr, 15, pmatch, 0);
    if (!ret) {
      oak_text_replace_string_sections(tmpstr, pmatch, foostr, replacestr);
      strcpy(tmpstr, foostr);
    }
  }

  /* and sendmail queue id's */
  if (oak_global_is_nukesmqid(&g)) {
    while (1) {
      ret=regexec(oak_global_get_regex_smqid(&g), tmpstr, 15, pmatch, 0);
      if (!ret) {
	oak_text_replace_string_sections(tmpstr, pmatch, foostr, replacestr);
	strcpy(tmpstr, foostr);
      } else {
	break;
      }
    }
  }

  /* check for a match */
  ret=regexec(&(m->regex), tmpstr, 15, pmatch, 0);
  if (ret) {
    strcpy(out, ""); /* not really necessary */
    free(tmpstr);
    free(foostr);
    return(0);
  }

  /* replace text if necessary */
  oak_text_replace_string_sections(tmpstr, pmatch, out, replacestr);
  free(tmpstr);
  free(foostr);

  return(1);
}

oak_queuelist *oak_matchline_get_queuelist(oak_matchline *m)
{
  /* return the queuelist associated with the matchline m */
  return(&(m->ql));
}

int oak_matchline_locked_for_queue(oak_matchline *m, oak_queue *q)
{
  /* if not do the clean up */
  int i, num;
  oak_queue *tmpq;
  time_t *tmptime;
  

  num=oak_list_get_size(&(m->locked_queuelist));
  for (i=0; i<num; i++) {
    tmpq=oak_list_get_element(&(m->locked_queuelist), i);
    if (tmpq != q) continue;

    tmptime=oak_list_get_element(&(m->lock_times), i);
    /* if the time is not up then it's locked, return 1 */
    if (*tmptime > time(NULL)) return(1);

    /* otherwise the lock has expired, we need to clean it up and then return 0 */
    oak_list_remove_element((&m->locked_queuelist), i);
    oak_list_remove_element(&(m->lock_times), i);
    free(tmptime);

    return(0);
  }

  /* never heard of that queue */
  return(0);
}

void oak_matchline_set_lock(oak_matchline *m, oak_queue *q)
{
  time_t *tmptime;
  time_t foo;
  
  if (oak_matchline_locked_for_queue(m, q)) {
    /* hrm, update the time probably, don't worry about it for now */
    return;
  }

  foo=time(NULL) + oak_queue_get_locktime(q);
  tmptime=malloc(sizeof(time_t));
  memcpy(tmptime, &foo, sizeof(time_t));

  oak_list_append_element(&(m->locked_queuelist), q);
  oak_list_append_element(&(m->lock_times), tmptime);
}
