#include "oak.h"
#include <stdlib.h>
#include <string.h>

/* initialize the queue_entry with 'msg' & 'host' with a rep count of
 * 1
 */
void oak_queue_entry_create(oak_queue_entry *qe, char *host, char *msg)
{
  qe->host=strdup(host);
  qe->msg=strdup(msg);
  qe->repcount=1;
}

/* return 1 if 'host' and and 'str' match the host and message in
 * this entry, otherwise return 0
 */
int oak_queue_entry_matches(oak_queue_entry *qe, char *host, char *str)
{
  if (!strcmp(qe->msg, str) && !strcasecmp(qe->host, host)) return(1);
  return(0);
}

void oak_queue_entry_up_repcount(oak_queue_entry *qe)
{
  qe->repcount++;
}

int oak_queue_entry_get_repcount(oak_queue_entry *qe)
{
  return(qe->repcount);
}

char *oak_queue_entry_get_msg(oak_queue_entry *qe)
{
  return(qe->msg);
}

char *oak_queue_entry_get_host(oak_queue_entry *qe)
{
  return(qe->host);
}

void oak_queue_entry_free(oak_queue_entry *qe)
{
  if (qe->host) free(qe->host);
  if (qe->msg) free(qe->msg);
}
