/* Edit this file in -*- c -*- mode. */

/* Open Digita Services  --  Camera Device Protocol definitions.
   
   Copyright (C) 1998, 1999 James C. Thompson <jim.thompson@pobox.com>
   Copyright (C) 1998, 1999 Viljo Hakala <viljo.hakala@pcuf.fi>
   
   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2 of the License, or (at your
   option) any later version.
   
   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#if !defined(_cdpP_h_)
#define _cdpP_h_

/*--------------------------------------------------------------------------
  Local include files */

#include "defs.h"

/* Start Editing Here: */

typedef struct _ODSBeacon 
{
  UINT16	intro;
  UINT16	vendor_id;
  UINT16	device_id;
  UCHAR8	checksum;
} ODSBeacon;

#define sizeof_beacon 7		        /* wire size */

typedef struct 
{
  UINT16	intro;
  UCHAR8	interface_type;
  unsigned int	cf_reserved:4;
  unsigned int	cf_pod_receive_mode:2;
  unsigned int	cf_host_receive_mode:2;
  UINT32	data_speed;
  UINT16	device_frame_size;
  UINT16	host_frame_size;
  UCHAR8	checksum;
} ODSBeaconAck;

#define sizeof_beacon_ack 13

typedef struct 
{
  UCHAR8	result;
  unsigned int	cf_reserved:4;
  unsigned int	cf_pod_receive_mode:2;
  unsigned int	cf_host_receive_mode:2;
  UINT32	data_speed __attribute__((aligned(2), packed));
  UINT16	device_frame_size;
  UINT16	host_frame_size;
} ODSBeaconComp;

typedef struct 
{
  unsigned int	length:10 __attribute__((packed));
  unsigned int	bob_flag:1 __attribute__((packed));
  unsigned int	eob_flag:1 __attribute__((packed));
  unsigned int	cmd_flag:1 __attribute__((packed));
  unsigned int	poll:3 __attribute__((packed));
} ODSPoll __attribute__((aligned(2), packed));

typedef struct 
{
  unsigned int	ack:1 __attribute__((packed));
  unsigned int	nak:1 __attribute__((packed));
  unsigned int	unused:14 __attribute__((packed));
} ODSPollAck __attribute__((aligned(2), packed));

#define sizeof_beacon_comp 10

#endif /* _cdpP_h_ */
       /* Do not add anything below this line! */
