#ifndef __PDBTOOLS_H__
#define __PDBTOOLS_H__
#include <iostream>
#include <string>
#include "libsupport/clp.h"
#include "libsupport/strop.h"
#include "libsupport/infofile.h"
#include "libsupport/csvfile.h"
#include "libflatfile/Factory.h"
#include "libflatfile/Database.h"
#include "libpalm/File.h"
#include "libpalm/palmtypes.h"

namespace PDBTools {
    class LibConfig
    {
        public:
            void setPDBPath(std::string p_Path)
                { m_PDBDirectory = p_Path;}
            std::string getPDBPath()
                { return m_PDBDirectory;}
            void setCSVConfig(DataFile::CSVConfig p_state)
                {m_CSVConfig = p_state; }
            DataFile::CSVConfig getCSVConfig()
                { return m_CSVConfig;}
        private:
            std::string m_PDBDirectory;
            DataFile::CSVConfig m_CSVConfig;
    };
    extern LibConfig  g_Config;
    void setConfigLib(std::ostream* p_err,
                std::string p_PDBPath = std::string("."),
                DataFile::CSVConfig p_State = DataFile::CSVConfig());
}

#endif
