/*
 * This class provides access to DB-format databases.
 */

#ifndef __PALMLIB_FLATFILE_OLDDB_H__
#define __PALMLIB_FLATFILE_OLDDB_H__

#include <string>

#include "libpalm/Database.h"
#include "Database.h"

namespace PalmLib {
    namespace FlatFile {

	class OldDB : public Database {
	public:
	    /**
	     * Return true if this class can handle the given PalmOS
	     * database.
	     *
	     * @param pdb PalmOS database to check for support.
	     */
	    static bool classify(PalmLib::Database& pdb);

	    /**
	     * Return true if this class is the database identified by
	     * name.
	     *
	     * @param name A database type name to check.
	     */
	    static bool match_name(const std::string& name);

	    /**
	     * Default constructor for an initially empty database.
	     */
	    OldDB()
            : Database("olddb")
            { }

	    /**
	     * Constructor which fills the flat-file structure from a
	     * PalmOS database.
	     */
	    OldDB(PalmLib::Database&);

	    // destructor
	    virtual ~OldDB() { }

            /**
             * After all processing to add fields and records is done,
             * outputPDB is called to create the actual file format
             * used by the flat-file database product.
             *
             * @param pdb An instance of PalmLib::Database.
	     */
            virtual void outputPDB(PalmLib::Database& pdb) const;

            /**
             * Return the maximum number of fields allowed in the
             * database. This class returns 0 since there is no limit.
	     */
            virtual unsigned getMaxNumOfFields() const;

	    /**
	     * Return true for the field types that this class
	     * currently supports. Returns false otherwise.
	     *
	     * @param type The field type to check for support.
	     */
	    virtual bool supportsFieldType(const Field::FieldType& type) const;

            /**
             * Return the maximum number of views supported by this
             * type of flat-file database.
	     */
	    virtual unsigned getMaxNumOfListViews() const;

	    /**
	     * Hook the end of schema processing.
	     */
	    virtual void doneWithSchema();

	    /**
	     * Set a extra option.
	     *
	     * @param opt_name  The name of the option to set.
	     * @param opt_value The value to assign to this option.
	     */
	    virtual void setOption(const std::string& opt_name,
				   const std::string& opt_value);

	    /**
	     * Get a list of extra options.
	     */
	    virtual options_list_t getOptions(void) const;

	private:
	    pi_uint16_t m_flags;
	    pi_uint16_t m_top_visible_record;
	};

    }
}

#endif
