#ifndef __CSVFILE_H__
#define __CSVFILE_H__

#include "infofile.h"
#include "libsupport/strop.h"

namespace DataFile {

    class CSVConfig
    {
    public:
        CSVConfig():
            implicit_listview(), extended_csv_mode(false), quoted_string(true),
            field_sep(","), format_date("%m/%d/%Y"),
            format_time("%H:%M"), format_datetime("%m/%d/%Y %H:%M"),
            csv_fname("stdIO")
            {}

        PalmLib::FlatFile::ListView implicit_listview;
        bool extended_csv_mode;
        bool quoted_string;
        std::string field_sep;
        std::string format_date;
        std::string format_time;
        std::string format_datetime;   
        std::string csv_fname;

		CSVConfig& operator = (const CSVConfig& from) {
            implicit_listview = from.implicit_listview;
            extended_csv_mode = from.extended_csv_mode;
            quoted_string = from.quoted_string;
            field_sep = from.field_sep;
            format_date = from.format_date;
            format_time = from.format_time;
            format_datetime = from.format_datetime;   
            csv_fname = from.csv_fname;
		    return *this;
		}
    };

    class CSVFile {
    public:
        CSVFile(std::string p_FileName)
            :m_FileName(p_FileName)
            {}
        void write(const PalmLib::FlatFile::Database& db,
			    const DataFile::CSVConfig& state);

        void read(PalmLib::FlatFile::Database& db,
                const DataFile::CSVConfig& state);
        PalmLib::FlatFile::Field string2field(PalmLib::FlatFile::Field::FieldType type,
                const std::string fldstr,
                const DataFile::CSVConfig& state);
        std::string field2string(PalmLib::FlatFile::Field field,
                const DataFile::CSVConfig& state);
    private:
        void write(std::ostream& csv, const PalmLib::FlatFile::Database& db,
			    const DataFile::CSVConfig& state);

        void read(std::istream& f, PalmLib::FlatFile::Database& db,
                const DataFile::CSVConfig& state);

        StrOps::string_list_t line2array(std::istream& f,
					std::string line,
					const DataFile::CSVConfig& state,
					int linenum);

        std::string m_FileName;

  };
}

#endif
