#ifndef __INFOFILE_H__
#define __INFOFILE_H__

#include <iostream>
#include <fstream>
#include <string>
#include "libflatfile/Database.h"
#include "csvfile.h"

namespace DataFile {

    class InfoFile
    {
    public:
        InfoFile()
            {}
        InfoFile(std::string p_Fname)
                :m_FileName(p_Fname)
            {}
        void setFileName(std::string fname)
            { m_FileName = fname;}

        void read(DataFile::CSVConfig& state) const;
        void read(PalmLib::FlatFile::Database& db) const;
        std::string readType() const;
        std::string readPDBPath() const;

        void write(const PalmLib::FlatFile::Database& flatfile,
                        DataFile::CSVConfig& state, std::string p_PDBPath = "");
        void write(DataFile::CSVConfig& state, std::string p_PDBPath = "");
    private:
        class Parser
        {
        public:
            virtual void parse(int linenum, std::vector< std::string> array) = 0;
        };
        class ConfigParser: public Parser
        {
            public:
                ConfigParser(DataFile::CSVConfig& state)
                    : m_Config(state)
                    {}
                virtual void parse(int linenum, std::vector< std::string> array);
            private:
                DataFile::CSVConfig& m_Config;
        };
        class DatabaseParser: public Parser
        {
            public:
                DatabaseParser(PalmLib::FlatFile::Database& db)
                    : m_DB(db)
                    {}
                virtual void parse(int linenum, std::vector< std::string> array);
            private:
                PalmLib::FlatFile::Database& m_DB;
        };
        class TypeParser: public Parser
        {
            public:
                TypeParser(std::string& p_Type)
                    : m_Type(p_Type)
                    {}
                virtual void parse(int linenum, std::vector< std::string> array);
            private:
                std::string& m_Type;
        };
         class PDBPathParser: public Parser
        {
            public:
                PDBPathParser(std::string& p_Path)
                    : m_Path(p_Path)
                    {}
                virtual void parse(int linenum, std::vector< std::string> array);
            private:
                std::string& m_Path;
        };
        void runParser(Parser * p_Parser) const;
        void writeDBInfo(std::ofstream& p_Info, const PalmLib::FlatFile::Database& flatfile, bool p_extended = false);
        void writeCSVInfo(std::ofstream& p_Info, DataFile::CSVConfig& state);
        void writePDBInfo(std::ofstream& p_Info, std::string p_PDBPath = std::string(""), bool p_extended = false);

        std::string m_FileName;
    };
}

#endif
