/*
   Copyright (c) 2000 MicroSource

   This source file and all accompanying files are the exclusive property
   of the author Paul Carapetis and MicroSource, and no modifications are
   to be performed on said source without expressed permission from the
   author or an authorised representative of MicroSource, unless the
   purpose of such modifications is to effect a successful compile on your
   platform.

   This source is only to be distributed in its complete form and only with
   all of the following files included:

        INSTALL
        README
        ibmchars.uu
        license.doc
        newargs.txt
        pcps.man
        register.doc

        makefile
        define.h
        pcps.c
        pcps.h
        struct.h
        unix.c
        unix.h
        valargs.h

   The utility "PCPS" is a SHAREWARE product and you, as the user, agree
   that the source will be removed from your filesystem once the utility
   has been successfully compiled and is found to be functional.  Any
   changes to the source that were required for a successful compile must
   be returned to the author for inclusion in the main source control.

   The utility may be trialed for the period of time mentioned in the file
   license.doc, but must either be registered or destroyed within said
   trial time.  The cost and method of registration is detailed in the file
   license.doc.

Author:  Paul Carapetis  Internet: Paul_Carapetis@iname.com
Company: MicroSource     Snail:    10 Denise Court
                                   Narre Warren
                                   Australia  3805

*/
#ifndef PCPS_PCPS
# define PCPS_PCPS
/*****************************************************************************/
/* PCPS.H - To accompany PCPS.C                                              */
/*****************************************************************************/

EnhChar C_Char[3] = {
  {"/*","*/"},
  {"//",0},
  0,0
};

EnhChar GL_Char[4] = {
  {"{","}"},
  {"#",0},
  {"--",0},
  0,0
};

EnhChar S_Char[2] = {
  {"#",0},
  0,0
};

EnhChar P_Char[3] = {
  {"(*","*)"},
  {"{","}"},
  0,0
};

EnhChar F_Char[2] = {
  {"*",0},
  0,0
};

pstat PaperStats[NUMPAPERSIZES] = {
  /* for use both for paper sizing and paper trays */
  {"a4",A4,A4"tray",A4_H,A4_W,A4_2UP},
  {"a3",A3,A3"tray",A3_H,A3_W,A3_2UP},
  {"a2",A2,A2"tray",A2_H,A2_W,A2_2UP},
  {"a1",A1,A1"tray",A1_H,A1_W,A1_2UP},
  {"a0",A0,A0"tray",A0_H,A0_W,A0_2UP},
  {"lt",LT,LT"tray",LT_H,LT_W,LT_2UP},
  {"lg",LG,LG"tray",LG_H,LG_W,LG_2UP},
  {"ex",EX,EX"tray",EX_H,EX_W,EX_2UP},
  {"co",CO,CO"tray",CO_H,CO_W,CO_2UP},
  {"mo",MO,MO"tray",MO_H,MO_W,MO_2UP},
  {"dl",DL,DL"tray",DL_H,DL_W,DL_2UP},
};

paper PInfo = {
  /*        Name Height Width Scale */
  /*        ----------------------- */
  /* A4 */  A4,  A4_H,  A4_W, A4_2UP,

                     /* Defaults */
/*       |    Portrait      |    Landscape      | */
/*       +------------------+-------------------+ */
/*       | L    R   Top  Bot|  L    R   Top  Bot| */
/*       ---------------------------------------- */
0,0,0,0,  720, 440, 720, 720, 440, 440, 720, 440,
};

font FontList[NUMBFONTS] = {       /* Font list */
/* 0  */  {"AGB","AvantGarde-Book",1,{1,1,1}},
/* 1  */  {"AGBO","AvantGarde-BookOblique",0,{0,0,0}},
/* 2  */  {"AGD","AvantGarde-Demi",3,{3,3,3}},
/* 3  */  {"AGDO","AvantGarde-DemiOblique",2,{2,2,2}},
/* 4  */  {"BD","Bookman-Demi",5,{5,5,5}},
/* 5  */  {"BDI","Bookman-DemiItalic",4,{4,4,4}},
/* 6  */  {"BL","Bookman-Light",7,{7,7,7}},
/* 7  */  {"BLI","Bookman-LightItalic",6,{6,6,6}},
/* 8  */  {"C","Courier",9,{9,11,10}},
/* 9  */  {"CB","Courier-Bold",10,{8,10,11}},
/* 10 */  {"CBO","Courier-BoldOblique",9,{11,9,8}},
/* 11 */  {"CO","Courier-Oblique",10,{10,8,9}},
/* 12 */  {"H","Helvetica",13,{13,19,14}},
/* 13 */  {"HB","Helvetica-Bold",14,{12,14,19}},
/* 14 */  {"HBO","Helvetica-BoldOblique",13,{19,13,12}},
/* 15 */  {"HN","Helvetica-Narrow",16,{16,18,17}},
/* 16 */  {"HNB","Helvetica-Narrow-Bold",17,{15,17,18}},
/* 17 */  {"HNBO","Helvetica-Narrow-BoldOblique",16,{18,16,15}},
/* 18 */  {"HNO","Helvetica-Narrow-Oblique",17,{17,15,16}},
/* 19 */  {"HO","Helvetica-Oblique",14,{14,12,13}},
/* 20 */  {"IBM",IBMF,9,{9,11,10}},
/* 21 */  {"NCSB","NewCenturySchlbk-Bold",22,{24,22,23}},
/* 22 */  {"NCSBI","NewCenturySchlbk-BoldItalic",21,{23,21,24}},
/* 23 */  {"NCSI","NewCenturySchlbk-Italic",22,{22,24,21}},
/* 24 */  {"NCSR","NewCenturySchlbk-Roman",21,{21,23,22}},
/* 25 */  {"PB","Palatino-Bold",26,{28,26,27}},
/* 26 */  {"PBI","Palatino-BoldItalic",25,{27,25,28}},
/* 27 */  {"PI","Palatino-Italic",26,{26,28,25}},
/* 28 */  {"PR","Palatino-Roman",25,{25,27,26}},
/* 29 */  {"S","Symbol",8,{29,29,29}},
/* 30 */  {"TB","Times-Bold",31,{33,31,32}},
/* 31 */  {"TBI","Times-BoldItalic",30,{32,30,33}},
/* 32 */  {"TI","Times-Italic",31,{31,33,30}},
/* 33 */  {"TR","Times-Roman",30,{30,32,31}},
/* 34 */  {"ZCMI","ZapfChancery-MediumItalic",34,{34,34,34}},
/* 35 */  {"ZD","ZapfDingbats",8,{35,35,35}},
};

/*****************************************************************************/
/*                       Postscript timing routine                           */
/*****************************************************************************/
char *PSTiming = {
"/oldtime usertime def\n"            /* set start time in oldtime */
"/scrstr 10 string def\n"            /* scratch string to display time */
"/prtime{\n"
"  /newtime usertime def\n"          /* set current time into newtime */
"  print ( : ) print\n"              /* print string given before call */
"  newtime oldtime sub 1000 div\n"   /* time since last call ms -> sec */
"  scrstr cvs print ( sec elapsed\\012) print\n" /* print it out */
"  /oldtime newtime def\n"           /* shift newtime into old time */
"}def\n"
"(Start of PCPS job.  Start Prolog : 0\\012) print\n"
};

/*****************************************************************************/
/* You will notice that many of the following defines have been made into    */
/* char arrays - this is for MSC6.0a which can't handle large strings.       */
/*****************************************************************************/

/*****************************************************************************/
/*                         Postscript Prolog                                 */
/*****************************************************************************/
char *Prolog[] = {
"/StartPCPSDoc{$PCPS begin}def\n"
"/$PCPS 200 dict def\n"
"$PCPS begin\n"
"/EndPCPSDoc{FP end}def\n"
"/S/show load def\n"
"/M{LeftMarg 3 2 roll moveto}def\n"
"/B{M S}def\n"
"/W{M (\\b) stringwidth pop 2 mul neg 0 8 4 3 roll widthshow}def\n"
"/F{$fd exch get setfont}def\n"
"/FP{\n"
" OSP{showpage /OSP false def /CurPg 1 def}{CurPg 1 gt{showpage /CurPg 1 def\n"
" DupMode{showpage}if}if}ifelse}def\n"
"/EndDoc{Flush{FP}if}def\n"
"/MB{\n"
" statusdict begin/manualfeed true store /manualfeedtimeout 360 store end}def\n"
"/ME{statusdict begin/manualfeed false store end}def\n"
"/DM{/DupMode exch def statusdict begin DupMode setduplexmode settumble\n"
" end}def/OSP false def\n"
"/WM{gsave /PCPSTimes-Bold findfont BackSize scalefont setfont /Angle LandMode\n"
" {30}{60}ifelse def LeftMarg PWidth 2 idiv add THeight 2 idiv translate Angle\n"
" rotate 0 BackText stringwidth pop cvi 2 div sub 0 translate 0 0 moveto .95\n"
" setgray BackText show grestore}def\n"
"/SPT{/Tray exch def statusdict begin Tray setpapertray end} def\n"
"/TM{3 F /HSize TMStr stringwidth pop def\n"
" LeftMarg 375 TMFSize 4 div sub moveto HSize 0 rlineto 0 TMFSize\n"
" rlineto HSize neg 0 rlineto closepath gsave 1 setgray fill grestore\n"
" newpath LeftMarg 375 moveto TMStr show}def\n"
,
"/UpStart{Scale dup scale/PW PgWidth Scale div def/PH PgHeight Scale div def\n"
/* for either 2 or 4 up, need this line */
" UpLines{0 PH 2 div moveto PW 0 rlineto 4 setlinewidth stroke}if\n"
" PgsUp 2 eq{LandMode{0 PH translate -90 rotate 0 PW 2 div translate}\n"
" {90 rotate 0 PW neg translate}ifelse}{\n"
/* This one just required for 4up */
" UpLines{PW 2 div 0 moveto 0 PH rlineto 4 setlinewidth stroke}if\n"
" 0 PH 2 div translate}ifelse}def\n"
"/StartPage{CurPg 1 eq{save /svpg exch def .05 dup scale LandMode{Landscape}if\n"
" PgsUp 1 ne{UpStart}if}{PgsUp 2 eq{LandMode{0 PW 2 div neg translate}\n"
" {PH 2 div 0 translate}ifelse}{CurPg 3 eq{PW 2 div neg PH 2 div neg translate}\n"
" {PW 2 div 0 translate}ifelse}ifelse}ifelse}def\n"
"/EndPage{CurPg PgsUp eq{/CurPg 1 def svpg restore showpage DupMode{/OSP OSP\n"
" {false}{true}ifelse def}if}{/CurPg CurPg 1 add def}ifelse}def\n"
"/SetUpFonts{dup/$fd exch array def{findfont exch scalefont $fd 3 1 roll put}\n"
" repeat}def\n"
"/M25Y{YDec 4 div sub}def\n"
"/ShadePage{\n"
" THeight YDec add YDec NLine mul 2 mul sub M25Y YDec NLine mul neg 2 mul BotLine\n"
" M25Y{LeftMarg exch moveto TWidth 0 rlineto 0 YDec NLine mul rlineto TWidth\n"
" neg 0 rlineto closepath gsave Shade setgray fill grestore newpath}for}def\n"
"/BoxPage{LeftMarg 40 sub BotLine 40 sub moveto TWidth 80 add 0 rlineto\n"
" 0 THeight BotLine sub YDec add 80 add rlineto TWidth 80 add neg 0 rlineto\n"
" closepath 4 setlinewidth stroke}def\n"
,0
};

/* stuff to redefine the european character set */
/* first the re-encoding routine */
char *ReEncEuro = {
"/reencsmalldict 12 dict def\n"
"/ReEncodeSmall{\n"
"  reencsmalldict begin/basefontname exch def/newfontname exch def\n"
"  /newcodesandnames exch def/basefontdict basefontname findfont def\n"
"  /newfont basefontdict maxlength dict def basefontdict {exch dup/FID ne{dup\n"
"  /Encoding eq{exch dup length array copy newfont 3 1 roll put}{exch newfont\n"
"  3 1 roll put}ifelse}{ pop pop }ifelse}forall newfont/FontName newfontname\n"
"  put newcodesandnames aload pop newcodesandnames length 2 idiv {newfont\n"
"  /Encoding get 3 1 roll put}repeat newfontname newfont definefont pop end\n"
"}def\n"
/* std PCPS European re-encode array of differences */
"/European [128/Ccedilla 129/udieresis 130/eacute 131/acircumflex\n"
" 132/adieresis 133/agrave 134/aring 135/ccedilla 136/ecircumflex\n"
" 137/edieresis 138/egrave 139/idieresis 140/icircumflex 141/igrave\n"
" 142/Adieresis 143/Aring 144/Eacute 145/ae 146/AE 147/ocircumflex\n"
" 148/odieresis 149/ograve 150/ucircumflex 151/ugrave 152/ydieresis\n"
" 153/Odieresis 154/Udieresis 155/cent 156/sterling 157/yen 159/florin\n"
" 160/aacute 161/iacute 162/oacute 163/uacute 164/ntilde 165/Ntilde\n"
" 168/questiondown 171/onehalf 172/onequarter 173/exclamdown 174/guillemotleft\n"
" 175/guillemotright 225/germandbls 237/oslash 241/plusminus\n"
" 246/divide 248/degree] def\n"
};

char *ReEncISO[] = {
"/NewEncode{\n"
" findfont begin currentdict dup length dict begin{1 index/FID ne{def}{pop pop}\n"
" ifelse}forall/FontName exch def/Encoding exch def currentdict dup end end\n"
" /FontName get exch definefont pop\n"
"}def\n"
/* full ISO-8859-1 or ISO-Latin-1 re-encode array */
"ISOLatin1Encoding where { pop } { ISOLatin1Encoding\n"
" [/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef\n"
" /.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef\n"
" /.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef\n"
" /.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/space\n"
" /exclam/quotedbl/numbersign/dollar/percent/ampersand/quoteright\n"
" /parenleft/parenright/asterisk/plus/comma/minus/period/slash/zero/one\n"
" /two/three/four/five/six/seven/eight/nine/colon/semicolon/less/equal\n"
" /greater/question/at/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S\n"
" /T/U/V/W/X/Y/Z/bracketleft/backslash/bracketright/asciicircum\n"
" /underscore/quoteleft/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s\n"
" /t/u/v/w/x/y/z/braceleft/bar/braceright/asciitilde/.notdef/.notdef\n"
,
" /.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef\n"
" /.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/dotlessi/grave\n"
" /acute/circumflex/tilde/macron/breve/dotaccent/dieresis/.notdef/ring\n"
" /cedilla/.notdef/hungarumlaut/ogonek/caron/space/exclamdown/cent\n"
" /sterling/currency/yen/brokenbar/section/dieresis/copyright/ordfeminine\n"
" /guillemotleft/logicalnot/hyphen/registered/macron/degree/plusminus\n"
" /twosuperior/threesuperior/acute/mu/paragraph/periodcentered/cedilla\n"
" /onesuperior/ordmasculine/guillemotright/onequarter/onehalf/threequarters\n"
" /questiondown/Agrave/Aacute/Acircumflex/Atilde/Adieresis/Aring/AE\n"
" /Ccedilla/Egrave/Eacute/Ecircumflex/Edieresis/Igrave/Iacute/Icircumflex\n"
" /Idieresis/Eth/Ntilde/Ograve/Oacute/Ocircumflex/Otilde/Odieresis\n"
" /multiply/Oslash/Ugrave/Uacute/Ucircumflex/Udieresis/Yacute/Thorn\n"
" /germandbls/agrave/aacute/acircumflex/atilde/adieresis/aring/ae\n"
" /ccedilla/egrave/eacute/ecircumflex/edieresis/igrave/iacute/icircumflex\n"
" /idieresis/eth/ntilde/ograve/oacute/ocircumflex/otilde/odieresis/divide\n"
" /oslash/ugrave/uacute/ucircumflex/udieresis/yacute/thorn/ydieresis]def\n"
"}ifelse\n"
,0
};

/*****************************************************************************/
/*                  for the gaudy banner                                     */
/*****************************************************************************/
char *Gaudy = {
"/GaudyInit{\n"
" /PBox exch def /TwoColumn exch def\n"
" /ft1/Times-Bold findfont 240 scalefont def\n"
" /ft2/PCPSTimes-Roman findfont 280 scalefont def\n"
" /ft3/Helvetica-Bold findfont 600 scalefont def\n"
"} def\n"
"/BOX{\n"
" /dy exch def /dx exch def /ytl exch def /xtl exch def /chcol exch def\n"
" /boxcol exch def /font exch def /fs exch 20 mul def /msg exch def\n"
" gsave xtl ytl moveto 0 dy neg rlineto dx 0 rlineto 0 dy rlineto closepath\n"
" gsave boxcol setgray fill grestore 0 setgray 4 setlinewidth stroke\n"
" /ypos ytl dy msg length fs mul sub 2 div sub fs .85 mul sub def\n"
" font setfont chcol setgray\n"
" msg {\n"
"  dup stringwidth pop 2 div xtl dx 2 div add exch sub ypos moveto\n"
"  chcol 1 eq {dup gsave show grestore 0 setgray true charpath stroke}\n"
"  {show} ifelse /ypos ypos fs sub def\n"
" }forall grestore\n"
"}def\n"
"/Gaudy{\n"
" /PHeight exch def /BoxSwap exch def /PgNo exch def\n"
" /DtTm exch def /File exch def /UserMsg exch def\n"
" LandMode{/BoxSwap false def}if\n"
" /LeftBox {LeftMarg PHeight 1440 720} def\n"
" /RightBox {PWidth LeftMarg add 1440 sub PHeight 1440 720} def\n"
" DtTm 12 ft1 .7 0 BoxSwap{RightBox}{LeftBox}ifelse BOX\n"
" [PgNo] 30 ft3 .7 1 BoxSwap{LeftBox}{RightBox}ifelse BOX\n"
" [File] 14 ft2 .94 0 LeftMarg 1440 add PHeight 360 sub PWidth 2880 sub 360 BOX\n"
" [UserMsg] 14 ft2 1 0 LeftMarg 1440 add PHeight PWidth 2880 sub 360 BOX\n"
" /YBot PHeight 720 sub def\n" /* Y co-ord of Bottom edge of banner */
" PBox{\n"
"  LeftMarg YBot moveto -40 0 rlineto 0 YBot BotLine sub 40 add neg\n"
"  rlineto PWidth 80 add 0 rlineto 0 YBot BotLine sub 40 add rlineto\n"
"  -40 0 rlineto stroke\n"
" }if\n"
" TwoColumn {\n"
"  PWidth 2 div LeftMarg add BotLine PBox{40 sub}if moveto 0 YBot BotLine sub\n"
"  PBox{40 add}if rlineto stroke\n"
" }if\n"
"}def\n"
};

/*****************************************************************************/
/*              the extended error handler                                   */
/*****************************************************************************/
char *Error_Handler[] = {
"%!\n"
"(PCPS Extended Error Handler )print\n"
"serverdict begin statusdict begin 0000 checkpassword\n"
"{(installed.\\n)print flush 0000 exitserver}\n"
"{(not installed - Bad Password!!!\\n)print flush stop}ifelse\n"
"/$brkpage 64 dict def $brkpage begin\n"
"/prnt\n"
" {dup type/stringtype ne{=string cvs}if dup length 6 mul/tx exch def/ty 10 def\n"
"  currentpoint/toy exch def/tox exch def 1 setgray newpath\n"
"  tox toy 2 sub moveto 0 ty rlineto tx 0 rlineto 0 ty neg rlineto\n"
"  closepath fill tox toy moveto 0 setgray show}bind def\n"
"/nl{currentpoint exch pop lmargin exch moveto 0 -10 rmoveto}def\n"
"/=={/cp 0 def typeprint nl}def /typeprint{dup type exec}readonly def\n"
"/lmargin 72 def /rmargin 72 def\n"
"/tprint\n"
"   {dup length cp add rmargin gt{nl/cp 0 def}if\n"
"    dup length cp add/cp exch def prnt}readonly def\n"
"/cvsprint{=string cvs tprint( )tprint}readonly def\n"
"/integertype{cvsprint}readonly def\n"
"/realtype{cvsprint}readonly def\n"
"/booleantype{cvsprint}readonly def\n"
"/operatortype{(--)tprint =string cvs tprint(-- )tprint}readonly def\n"
"/marktype{pop(-mark- )tprint}readonly def\n"
"/dicttype{pop(-dictionary- )tprint}readonly def\n"
"/nulltype{pop(-null- )tprint}readonly def\n"
"/filetype{pop(-filestream- )tprint}readonly def\n"
"/savetype{pop(-savelevel- )tprint}readonly def\n"
"/fonttype{pop(-fontid- )tprint}readonly def\n"
"/nametype{dup xcheck not{(/)tprint}if cvsprint}readonly def\n"
,
"/stringtype\n"
" {dup rcheck{(\\()tprint tprint(\\))tprint}{pop(-string- )tprint}ifelse\n"
" }readonly def\n"
"/arraytype\n"
" {dup rcheck{dup xcheck\n"
"  {({)tprint{typeprint}forall(})tprint}\n"
"  {([)tprint{typeprint}forall(])tprint}ifelse}{pop(-array- )tprint}ifelse\n"
" }readonly def\n"
"/packedarraytype\n"
" {dup rcheck{dup xcheck\n"
"  {({)tprint{typeprint}forall(})tprint}\n"
"  {([)tprint{typeprint}forall(])tprint}ifelse}{pop(-packedarray- )tprint}ifelse\n"
" }readonly def\n"
"/courier/Courier findfont 10 scalefont def\n"
"end %$brkpage\n"
"errordict/handleerror\n"
" {systemdict begin $error begin $brkpage begin newerror\n"
"   {/newerror false store\n"
"    vmstatus pop pop 0 ne{grestoreall}if initgraphics courier setfont\n"
"    lmargin 720 moveto(  Error: )prnt errorname prnt\n"
"    nl(  Offending Command: )prnt/command load prnt\n"
"    $error/ostack\n"
"    known{nl nl(  Stack: )prnt nl nl $error/ostack get aload length{==}repeat}if\n"
"    systemdict/showpage get exec(%%[ Error: )print\n"
"    errorname =print(; OffendingCommand: )print/command\n"
"    load =print( ]%%)= flush}if end end end}\n"
"dup 0 systemdict put dup 4 $brkpage put bind readonly put\n"
,0
};

/*****************************************************************************/
/*                     The IBM extended char set                             */
/*****************************************************************************/
char *IBMPCFont[] = {
"/BuildCharDict 10 dict def\n"
"European/PCPSCourier/Courier ReEncodeSmall/a{arc}def/an{arcn}def\n"
"/cp{closepath}def/GetC{/PCPSCourier findfont 1000 scalefont setfont 0 0\n"
"moveto show}def/GetS{/Symbol findfont 1000 scalefont setfont 0 0 moveto show}\n"
"def/lt{lineto}def/mt{moveto}def/np{newpath}def/rlt{rlineto}def/rmt{rmoveto}def\n"
"/slw{setlinewidth}def/slc{setlinecap}def/squash{1 dict begin/cr exch def\n"
" save 1 .75 scale cr GetC restore end}def/newfont 60 dict def newfont begin\n"
"/FontType 3 def/FontMatrix [.001 0 0 .001 0 0] def/FontBBox [0 -200 600 877] def\n"
"/Encoding 256 array def 0 1 255{Encoding exch/.notdef put}for\n"
"Encoding dup 1/wsmiley put dup 2/bsmiley put dup 3/heart put dup 4/diamond\n"
"put dup 5/club put dup 6/spade put dup 7/blackdot put dup 8/whitedot\n"
,
"put dup 9/circle put dup 10/whitecircle put dup 11/mars put dup 12/venus put\n"
"dup 13/quaver put dup 14/doublequaver put dup 15/sun put dup 16/rarrowhead\n"
"put dup 17/larrowhead put dup 18/updowna put dup 19/exclamdbl put dup 20\n"
"/para put dup 21/section put dup 22/bar put dup 23/updownua put dup 24\n"
"/uparrow put dup 25/dnarrow put dup 26/rtarrow put dup 27/lfarrow put dup 28\n"
"/lblcorn put dup 29/btarrow put dup 30/uarrowhead put dup 31/darrowhead put\n"
"dup 33/exclamation put dup 34/doublequote put dup 35/poundsign put dup 36\n"
"/dollarsign put dup 37/percent put dup 38/ampersand put dup 39/quote put\n"
"dup 40/leftparen put dup 41/rightparen put dup 42/asterix put dup 43\n"
"/plussign put dup 44/comma put dup 45/minussign put dup 46/period put dup 47\n"
"/slashchar put dup 48/0 put dup 49/1 put dup 50/2 put dup 51/3 put dup 52\n"
"/4 put dup 53/5 put dup 54/6 put dup 55/7 put dup 56/8 put dup 57/9 put\n"
"dup 58/colon put dup 59/semicolon put dup 60/lessthan put dup 61/equals put\n"
"dup 62/greaterthan put dup 63/questionmark put dup 64/atsign put dup 65/A\n"
"put dup 66/B put dup 67/C put dup 68/D put dup 69/E put dup 70/F put dup\n"
"71/G put dup 72/H put dup 73/I put dup 74/J put dup 75/K put dup 76/L put\n"
"dup 77/M put dup 78/N put dup 79/O put dup 80/P put dup 81/Q put dup 82/R\n"
,
"put dup 83/S put dup 84/T put dup 85/U put dup 86/V put dup 87/W put dup\n"
"88/X put dup 89/Y put dup 90/Z put dup 91/leftbracket put dup 92/backslash\n"
"put dup 93/rightbracket put dup 94/caret put dup 95/underline put dup 96\n"
"/backquote put dup 97/a put dup 98/b put dup 99/c put dup 100/d put dup 101\n"
"/e put dup 102/f put dup 103/g put dup 104/h put dup 105/i put dup 106/j\n"
"put dup 107/k put dup 108/l put dup 109/m put dup 110/n put dup 111/o put\n"
"dup 112/p put dup 113/q put dup 114/r put dup 115/s put dup 116/t put dup\n"
"117/u put dup 118/v put dup 119/w put dup 120/x put dup 121/y put dup 122\n"
"/z put dup 123/leftcurly put dup 124/verticalsign put dup 125/rightcurly put\n"
"dup 126/tildesign put dup 127/Delta put dup 128/Ccedilla put dup 129\n"
"/udieresis put dup 130/eacute put dup 131/acircumflex put dup 132/adieresis\n"
"put dup 133/agrave put dup 134/aring put dup 135/ccedilla put dup 136\n"
"/ecircumflex put dup 137/edieresis put dup 138/egrave put dup 139/idieresis\n"
"put dup 140/icircumflex put dup 141/igrave put dup 142/Adieresis put dup\n"
"143/Aring put dup 144/Eacute put dup 145/ae put dup 146/AE put dup 147\n"
"/ocircumflex put dup 148/odieresis put dup 149/ograve put dup 150\n"
"/ucircumflex put dup 151/ugrave put dup 152/ydieresis put dup 153/Odieresis\n"
"put dup 154/Udieresis put dup 155/cent put dup 156/sterling put dup 157/yen\n"
"put dup 158/Psubt put dup 159/integral put dup 160/aacute put dup 161\n"
"/iacute put dup 162/oacute put dup 163/uacute put dup 164/ntilde put dup 165\n"
"/Ntilde put dup 166/aunder put dup 167/ounder put dup 168/questiondown put\n"
"dup 169/ltlcorn put dup 170/ltrcorn put dup 171/half put dup 172/quarter\n"
"put dup 173/exclamdown put dup 174/lessdbl put dup 175/greaterdbl put dup\n"
"176/xhatch1 put dup 177/xhatch2 put dup 178/xhatch3 put dup 179/vers put\n"
"dup 180/rtss put dup 181/rtds put dup 182/rtsd put dup 183/trsd put dup\n"
"184/trds put dup 185/rtdd put dup 186/verd put dup 187/trdd put dup 188\n"
"/brdd put dup 189/brsd put dup 190/brds put dup 191/trss put dup 192/blss\n"
,
"put dup 193/btss put dup 194/ttss put dup 195/ltss put dup 196/hors put\n"
"dup 197/crss put dup 198/ltds put dup 199/ltsd put dup 200/bldd put dup 201\n"
"/tldd put dup 202/btdd put dup 203/ttdd put dup 204/ltdd put dup 205/hord\n"
"put dup 206/crdd put dup 207/btds put dup 208/btsd put dup 209/ttds put\n"
"dup 210/ttsd put dup 211/blsd put dup 212/blds put dup 213/tlds put dup 214\n"
"/tlsd put dup 215/crsd put dup 216/crds put dup 217/brss put dup 218/tlss\n"
"put dup 219/block put dup 220/blockb put dup 221/blockl put dup 222/blockr\n"
"put dup 223/blockt put dup 224/alpha put dup 225/beta put dup 226/Gamma put\n"
"dup 227/pi put dup 228/Sigma put dup 229/sigma put dup 230/mu put dup 231\n"
"/tau put dup 232/Phi put dup 233/theta put dup 234/Omega put dup 235/delta\n"
"put dup 236/infinity put dup 237/phi put dup 238/element put dup 239\n"
"/intersec put dup 240/equiv put dup 241/plusminus put dup 242/greaterequal\n"
"put dup 243/lessequal put dup 244/integraltp put dup 245/integralbt put\n"
"dup 246/divide put dup 247/approxequal put dup 248/degree put dup 249\n"
"/bullet put dup 250/dotmath put dup 251/radical put dup 252/eta put dup 253\n"
"/sup2 put 254/squaredot put\n"
"/CharProcs 300 dict def CharProcs begin/.notdef{}def/wsmiley{np 300 300\n"
" 280 0 360 arc cp 40 slw stroke 300 300 150 210 330 arc 1 slc stroke 200 400\n"
" 40 0 360 arc cp fill 400 400 40 0 360 arc cp fill}def\n"
" /bsmiley{np 100 slw 300 300 250 45 405 arc stroke 400 400 100 90 450 arc\n"
" stroke 200 400 100 90 630 arc 20 300 mt 580 300 lt stroke 50 slw 300 500 50\n"
" 0 360 a stroke}def\n"
" /whitedot{np 0 -200 mt 600 -200 lt 600 800 lt 0 800 lt 0 -200 lt 300 300 200\n"
" 225 585 a eofill } def"
/* 0a don't even know if this works as we don't print lf's */
" /whitecircle {np 0 -200 mt 600 -200 lt 600 800 lt 0 800 lt 0\n"
" -200 lt 300 300 125 225 585 a 300 300 75 0 360 a eofill } def\n"
" /heart{(\\251)GetS}def/diamond{(\\250) GetS}def/club{(\\247) GetS}def/spade\n"
" {(\\252) GetS}def/blackdot{(\\267)GetC}def/circle{np 300 300 270 0 360 arc\n"
" cp stroke}def\n"
" /mars{np 200 200 170 0 360 arc cp stroke 341 341 mt 470 470 lt stroke\n"
,
" 550 550 mt 550 390 lt 390 550 lt 550 550 lt cp fill}def/venus{np 300 500\n"
" 170 0 360 arc cp stroke 300 0 mt 300 300 lt 150 150 mt 450 150 lt stroke}def\n"
" /quaver{300 150 translate gsave 30 rotate 1.5 1 scale np -100 0 100 0 360\n"
" arc cp fill grestore np 0 0 mt 0 550 lt stroke 0 550 mt 0 0 200 550 200\n"
" 120 curveto 200 550 0 550 0 500 curveto cp fill}def/doublequaver{np 250\n"
" 300 mt 250 700 lt 550 550 lt 550 150 lt stroke gsave 250 300 translate 30\n"
" rotate 1.5 1 scale np -100 0 100 0 360 arc cp fill grestore gsave 550 150\n"
" translate 30 rotate 1.5 1 scale np -100 0 100 0 360 arc cp fill grestore\n"
" }def/sun{np 300 300 150 270 -90 an 300 0 lt 180 180 mt 100 100 lt 150 300\n"
" mt 25 300 lt 180 420 mt 100 500 lt 300 450 mt 300 600 lt 420 420 mt 500 500 lt\n"
" 450 300 mt 575 300 lt 420 180 mt 500 100 lt 20 slw 1 slc stroke}def/rarrowhead\n"
" {np 600 300 mt 0 600 lt 0 0 lt 600 300 lt cp fill}def/larrowhead{np\n"
" 0 300 mt 600 600 lt 600 0 lt 0 300 lt cp fill}def/updowna{300 700 mt 550 500\n"
" lt 350 500 lt 350 200 lt 550 200 lt 300 0 lt 50 200 lt 250 200 lt 250 500 lt\n"
" 50 500 lt cp fill}def/exclamdbl{/Times-Roman findfont 1000 scalefont setfont\n"
" 0 0 mt -100 0 (!!) ashow}def/para{(\\266) GetC}def/section{(\\247) GetC}def\n"
" /bar{np 50 200 mt 50 400 lt 550 400 lt 550 200 lt 50 200 lt cp fill}def\n"
" /updownua{300 700 mt 550 500 lt 350 500 lt 350 200 lt 550 200 lt 300 0 lt 50\n"
" 200 lt 250 200 lt 250 500 lt 50 500 lt cp fill 0 0 mt 600 0 lt 20 slw stroke\n"
" }def/uparrow{300 700 mt 550 500 lt 350 500 lt 350 0 lt 250 0 lt 250 500 lt 50\n"
" 500 lt cp fill}def/dnarrow{300 0 mt 550 200 lt 350 200 lt 350 700 lt 250 700\n"
" lt 250 200 lt 50 200 lt cp fill}def/rtarrow{PrintCZ{50 300 mt 550 300 lt 300\n"
" 400 lt 550 300 mt 300 200 lt 1 slc 25 slw stroke}{}ifelse}def/lfarrow{550 300\n"
" mt 50 300 lt 300 400 lt 50 300 mt 300 200 lt 1 slc 25 slw stroke}def/lblcorn\n"
" {np 30 300 mt 30 30 lt 600 30 lt stroke}def/btarrow{550 300 mt 50 300 lt 200\n"
" 400 lt 50 300 mt 200 200 lt 550 300 mt 400 400 lt 550 300 mt 400 200 lt 1 slc\n"
,
" 20 slw stroke}def/uarrowhead{np 0 0 mt 600 0 lt 300 700 lt 0 0 lt cp fill}def\n"
" /darrowhead{np 0 700 mt 600 700 lt 300 0 lt 0 700 lt cp fill}def\n"
" /exclamation{(\\041)GetC}def/doublequote{(\\042)GetC}def/poundsign{(\\043)GetC\n"
" }def/dollarsign{(\\044)GetC}def/percent{(\\045)GetC}def/ampersand{(\\046)GetC\n"
" }def/quote{(\\047)GetC}def/leftparen{(\\050)GetC}def/rightparen{(\\051)GetC}\n"
" def/asterix{(\\052)GetC}def/plussign{(\\053)GetC}def/comma{(\\054)GetC}def\n"
" /minussign{(\\055)GetC}def/period{(\\056)GetC}def/slashchar{(\\057)GetC}def\n"
" /0{(0)GetC}def/1{(1)GetC}def/2{(2)GetC}def/3{(3)GetC}def/4{(4)GetC}def/5{(5)\n"
" GetC}def/6{(6)GetC}def/7{(7)GetC}def/8{(8)GetC}def/9{(9)GetC}def/colon{(\\072)\n"
" GetC}def/semicolon{(\\073)GetC}def/lessthan{(\\074)GetC}def/equals{(\\075)GetC\n"
" }def/greaterthan{(\\076)GetC}def/questionmark{(\\077)GetC}def/atsign{(\\100)\n"
" GetC}def/A{(A)GetC}def/B{(B)GetC}def/C{(C)GetC}def/D{(D)GetC}def/E{(E)GetC}def\n"
" /F{(F)GetC}def/G{(G)GetC}def/H{(H)GetC}def/I{(I)GetC}def/J{(J)GetC}def/K{(K)\n"
" GetC}def/L{(L)GetC}def/M{(M)GetC}def/N{(N)GetC}def/O{(O)GetC}def/P{(P)GetC}def\n"
" /Q{(Q)GetC}def/R{(R)GetC}def/S{(S)GetC}def/T{(T)GetC}def/U{(U)GetC}def/V{(V)\n"
" GetC}def/W{(W)GetC}def/X{(X)GetC}def/Y{(Y)GetC}def/Z{(Z)GetC}def/leftbracket{\n"
" (\\133)GetC}def/backslash{(\\134)GetC}def/rightbracket{(\\135)GetC}def/caret{\n"
" (\\136)GetC}def/underline{(\\137)GetC}def/backquote{(\\140)GetC}def/a{(a)GetC\n"
" }def/b{(b)GetC}def/c{(c)GetC}def/d{(d)GetC}def/e{(e)GetC}def/f{(f)GetC}def/g{\n"
" (g)GetC}def/h{(h)GetC}def/i{(i)GetC}def/j{(j)GetC}def/k{(k)GetC}def/l{(l)GetC\n"
" }def/m{(m)GetC}def/n{(n)GetC}def/o{(o)GetC}def/p{(p)GetC}def/q{(q)GetC}def/r{\n"
" (r)GetC}def/s{(s)GetC}def/t{(t)GetC}def/u{(u)GetC}def/v{(v)GetC}def/w{(w)GetC\n"
" }def/x{(x)GetC}def/y{(y)GetC}def/z{(z)GetC}def/leftcurly{(\\173)GetC}def\n"
" /verticalsign{(\\174)GetC}def/rightcurly{(\\175)GetC}def/tildesign{(\\176)GetC\n"
" }def/Delta{50 0 mt 50 200 lt 300 500 lt 550 200 lt 550 0 lt cp 0 setlinejoin\n"
,
" 20 slw stroke}def/Ccedilla{(\\200) GetC}def/udieresis{(\\201) GetC}def/eacute{\n"
" (\\202) GetC}def/acircumflex{(\\203) GetC}def/adieresis{(\\204) GetC}def\n"
" /agrave{(\\205) GetC}def/aring{(\\206) GetC}def/ccedilla{(\\207) GetC}def\n"
" /ecircumflex{(\\210) GetC}def/edieresis{(\\211) GetC}def/egrave{(\\212) GetC}\n"
" def/idieresis{(\\213) GetC}def/icircumflex{(\\214) GetC}def/igrave{(\\215)\n"
" GetC}def/Adieresis{(\\216) GetC}def/Aring{(\\217) GetC}def/Eacute{(\\220)\n"
" GetC}def/ae{(\\221) GetC}def/AE{(\\222) GetC}def/ocircumflex{(\\223) GetC}def\n"
" /odieresis{(\\224) GetC}def/ograve{(\\225) GetC}def/ucircumflex{(\\226) GetC}\n"
" def/ugrave{(\\227) GetC}def/ydieresis{(\\230) GetC}def/Odieresis{(\\231) GetC\n"
" }def/Udieresis{(\\232) GetC}def/cent{DanishFix{(\\371)}{(\\233)}ifelse GetC}def\n"
" /sterling{(\\234) GetC}def/yen{DanishFix{(\\351)}{(\\235)}ifelse GetC}def/Psubt\n"
" {/Times-Roman findfont dup 1000 scalefont setfont 0 0 mt (P) show 667\n"
" scalefont setfont 250 -80 mt (t) show}def/integral{(\\362) GetS}def/aacute\n"
" {(a) GetC (\\302) GetC}def/iacute{(i) GetC (\\302) GetC}def/oacute{(o) GetC\n"
" (\\302) GetC}def/uacute{(u) GetC (\\302) GetC}def/ntilde{(n) GetC (\\304)\n"
" GetC}def/Ntilde{(N) squash (\\304) GetC}def/aunder{save 175 200 translate .6\n"
" .6 scale (a) GetC 100 -200 mt 500 -200 lt 20 slw stroke restore}def/ounder{\n"
" save 175 200 translate .6 .6 scale (o) GetC 100 -200 mt 500 -200 lt 20 slw\n"
" stroke restore}def/questiondown{(\\277) GetC}def/ltlcorn{np 30 0 mt 30 300 lt\n"
" 600 300 lt stroke}def/ltrcorn{np 0 300 mt 570 300 lt 570 0 lt stroke}def\n"
" /half{/Times-Roman findfont 600 scalefont setfont\n"
" 0 300 mt (1) show 240 -100 mt (2) show np 70 150 mt 530 460 lt 36 slw\n"
" stroke}def/quarter{/Times-Roman findfont 600 scalefont setfont 0 300 mt (1)\n"
" show 240 -100 mt (4) show np 70 150 mt 530 460 lt 36 slw stroke}def\n"
" /exclamdown{(\\241) GetC}def/lessdbl{(\\256) GetC}def/greaterdbl{(\\273) GetC\n"
" }def/xhatch1{0 200 400{-200 200 600{exch dup 3 -1 roll np mt 40 40 rmt\n"
" 0 20 rlt 20 0 rlt 0 -20 rlt -20 0 rlt cp fill}for pop}for 100 200 500{-100 200\n"
,
" 700{exch dup 3 -1 roll np mt 40 40 rmt 0 20 rlt 20 0 rlt 0 -20 rlt -20 0\n"
" rlt cp fill}for pop}for}def/xhatch2{0 200 400{-200 200 600{exch dup 3 -1 roll\n"
" np mt 20 20 rmt 0 60 rlt 60 0 rlt 0 -60 rlt -60 0 rlt cp fill}for pop}for\n"
" 100 200 500{-100 200 700{exch dup 3 -1 roll np mt 20 20 rmt 0 60 rlt 60 0\n"
" rlt 0 -60 rlt -60 0 rlt cp fill}for pop}for}def/xhatch3{0 200 400{-200 200\n"
" 600{exch dup 3 -1 roll np mt 0 100 rlt 100 0 rlt 0 -100 rlt -100 0 rlt\n"
" cp fill}for pop}for 100 200 500{-100 200 700{exch dup 3 -1 roll np mt 0\n"
" 100 rlt 100 0 rlt 0 -100 rlt -100 0 rlt cp fill}for pop}for}def/vers{np\n"
" 300 -200 mt 300 877 lt stroke}def/rtss{np 300 -200 mt 300 877 lt 0 300\n"
" mt 300 300 lt stroke}def/rtds{np 300 -200 mt 300 877 lt 0 200 mt 300 200\n"
" lt 0 400 mt 300 400 lt stroke}def/rtsd{np 200 -200 mt 200 877 lt 400 -200\n"
" mt 400 877 lt 0 300 mt 200 300 lt stroke}def/trsd{np 0 300 mt 400 300 lt\n"
" 400 -200 lt 200 300 mt 200 -200 lt stroke}def/trds{np 0 400 mt 300 400 lt\n"
" 300 -200 lt 0 200 mt 300 200 lt stroke}def/rtdd{np 400 -200 mt 400 877 lt\n"
" 0 200 mt 200 200 lt 200 -200 lt 0 400 mt 200 400 lt 200 877 lt stroke}def/verd\n"
" {np 200 -200 mt 200 877 lt 400 -200 mt 400 877 lt stroke}def/trdd{np\n"
" 0 400 mt 400 400 lt 400 -200 lt 0 200 mt 200 200 lt 200 -200 lt stroke}def\n"
" /brdd{np 0 200 mt 400 200 lt 400 877 lt 0 400 mt 200 400 lt 200 877 lt\n"
" stroke}def/brsd{np 0 300 mt 400 300 lt 400 877 lt 200 300 mt 200 877 lt\n"
" stroke}def/brds{np 0 200 mt 300 200 lt 300 877 lt 0 400 mt 300 400 lt\n"
" stroke}def/trss{np 0 300 mt 300 300 lt 300 -200 lt stroke}def/blss{\n"
" np 300 877 mt 300 300 lt 600 300 lt stroke}def/btss{np 0 300 mt 600\n"
" 300 lt 300 300 mt 300 877 lt stroke}def/ttss{np 0 300 mt 600 300 lt 300\n"
" 300 mt 300 -200 lt stroke}def/ltss{np 300 -200 mt 300 877 lt 300 300 mt\n"
" 600 300 lt stroke}def/hors{np 0 300 mt 600 300 lt\n"
" stroke}def/crss{np 0 300 mt 600 300 lt 300 -200 mt 300 877 lt stroke}def\n"
,
" /ltds{np 300 -200 mt 300 877 lt 300 200 mt 600 200 lt 300 400 mt 600 400\n"
" lt stroke}def/ltsd{np 200 -200 mt 200 877 lt 400 -200 mt 400 877 lt 400\n"
" 300 mt 600 300 lt stroke}def/bldd{np 200 877 mt 200 200 lt 600 200 lt 400\n"
" 877 mt 400 400 lt 600 400 lt stroke}def/tldd{np 200 -200 mt 200 400 lt\n"
" 600 400 lt 400 -200 mt 400 200 lt 600 200 lt stroke}def/btdd{np 0 200 mt\n"
" 600 200 lt 0 400 mt 200 400 lt 200 877 lt 400 877 mt 400 400 lt 600 400 lt\n"
" stroke}def/ttdd{np 0 400 mt 600 400 lt 0 200 mt 200 200 lt 200 -200 lt\n"
" 400 -200 mt 400 200 lt 600 200 lt stroke}def/ltdd{np 200 -200 mt 200 877\n"
" lt 400 -200 mt 400 200 lt 600 200 lt 400 877 mt 400 400 lt 600 400 lt stroke\n"
" }def/hord{np 0 200 mt 600 200 lt 0 400 mt 600 400 lt stroke}def/crdd{\n"
" np 0 400 mt 200 400 lt 200 877 lt 400 877 mt 400 400 lt 600 400 lt 400\n"
" -200 mt 400 200 lt 600 200 lt 0 200 mt 200 200 lt 200 -200 lt stroke}def/btds{\n"
" np 0 200 mt 600 200 lt 0 400 mt 600 400 lt 300 400 mt 300 877 lt stroke\n"
" }def/btsd{np 0 300 mt 600 300 lt 200 300 mt 200 877 lt 400 300 mt 400 877\n"
" lt stroke}def/ttds{np 0 400 mt 600 400 lt 0 200 mt 600 200 lt 300 200 mt\n"
" 300 -200 lt stroke}def/ttsd{np 0 300 mt 600 300 lt 200 300 mt 200 -200 lt\n"
" 400 300 mt 400 -200 lt stroke}def/blsd{np 200 877 mt 200 300 lt 600 300\n"
" lt 400 877 mt 400 300 lt stroke}def/blds{np 300 877 mt 300 200 lt 600 200\n"
" lt 300 400 mt 600 400 lt stroke}def/tlds{np 300 -200 mt 300 400 lt 600\n"
" 400 lt 300 200 mt 600 200 lt stroke}def/tlsd{np 200 -200 mt 200 300 lt\n"
" 600 300 lt 400 -200 mt 400 300 lt stroke}def/crsd{np 0 300 mt 600 300 lt\n"
" 200 -200 mt 200 877 lt 400 -200 mt 400 877 lt stroke}def/crds{np 0 200 mt\n"
" 600 200 lt 0 400 mt 600 400 lt 300 -200 mt 300 877 lt stroke}def/brss{np\n"
" 0 300 mt 300 300 lt 300 877 lt stroke}def/tlss{np 300 -200 mt 300 300 lt\n"
" 600 300 lt stroke}def/block{np 0 -200 mt 0 877 lt 600 877 lt 600 -200 lt\n"
" 0 -200 lt cp fill}def/blockb{np 0 -200 mt 0 300 lt 600 300 lt 600 -200 lt\n"
,
" 0 -200 lt cp fill}def/blockl{np 0 -200 mt 0 877 lt 300 877 lt 300 -200 lt\n"
" 0 -200 lt cp fill}def/blockr{np 300 -200 mt 300 877 lt 600 877 lt 600\n"
" -200 lt 300 -200 lt cp fill}def/blockt{np 0 300 mt 0 877 lt 600 877 lt\n"
" 600 300 lt 0 300 lt cp fill}def/alpha{save .8 .8 scale (\\141) GetS restore}\n"
" def/beta{save .9 1 scale  (\\373) GetC restore}def/Gamma{save .8 .8 scale\n"
" (\\107) GetS restore}def/pi{save .8 .8 scale (\\160) GetS restore}def/Sigma{\n"
" save .8 .8 scale (\\123) GetS restore}def/sigma{save .8 .8 scale (\\163) GetS\n"
" restore}def/mu{save .8 .8 scale (\\155) GetS restore}def/tau{save .8 .8 scale\n"
" (\\164) GetS restore}def/Phi{save .75 1 scale (\\106) GetS restore}def/theta{\n"
" save .8 .8 scale (\\161) GetS restore}def/Omega{save .6 .9 scale (\\127) GetS\n"
" restore}def/delta{save .8 .8 scale (\\144) GetS restore}def/infinity{save .75\n"
" 1 scale (\\245) GetS restore}def/phi{save .8 .7 scale (\\146) GetS restore}def\n"
" /element{save .8 .8 scale (\\316) GetS restore}def/intersec{save .5 .8 scale\n"
" (\\307) GetS restore}def/equiv{(\\272) GetS}def/plusminus{(\\261) GetS}def\n"
" /greaterequal{(\\263) GetS}def/lessequal{(\\243) GetS}def/integraltp{save .75\n"
" .75 scale (\\363) GetS restore}def/integralbt{save .75 .75 scale (\\365) GetS\n"
" restore}def/divide{(\\270) GetS}def/approxequal{(\\273) GetS}def/degree{\n"
" (\\260) GetS}def/bullet{(\\267) GetS}def/dotmath{(\\327) GetS}def/radical{100\n"
" 300 mt 150 350 lt 350 0 lt 550 600 lt 25 slw stroke}def/eta{save .8 .8 scale\n"
" (\\150) GetS restore}def/sup2{/Times-Roman findfont 600 scalefont setfont 120\n"
" 380 mt (2) show}def/squaredot{np 200 200 mt 200 400 lt 400 400 lt 400 200\n"
" lt 200 200 lt cp fill}def end\n"
"/BuildChar{BuildCharDict begin 60 setlinewidth /char exch def /fontdict exch\n"
" def /charname fontdict /Encoding get char get def /charproc fontdict\n"
" /CharProcs get charname get def 600 0 0 -200 600 877 setcachedevice gsave\n"
" charproc grestore end}def end\n"
" /"IBMF" newfont definefont pop\n"
,0,
};

/*****************************************************************************/
/*                     The usage message                                     */
/*****************************************************************************/

char *HelpMessage[] = {
"\tUsage: pcps [-arg1 -arg2 ... -argn] [input_file(s)]<cr>",
"",
" [input_file(s)] = Pathname of input text file(s) (Wildcards allowed)",
"                   If no file names are specified, input is taken from stdin",
"",
" [-arg1...-argn] = Optional arguments as listed below.  Fields enclosed in []",
"                   are optional but they are mandatory when enclosed in <> ",
"",
"             -he = Show this page.           (other args ignored)",
"             -ls = List available Font Codes.(other args ignored)",
"        -ap<o|e> = Print alternate pages where o = Odd and e = Even.",
"             -bx = Draw a BoX around the printable area on the page.",
"             -cd = Put Ctl-D at start and end of print job.",
"          -cp<n> = Print \"n\" copies of each page                  (Default = 1)",
"             -cz = Do not print the Ctl-Z (0x1A = DOS EOF) character.",
"      -df<s|o|p> = Default action to take on files already in PostScript where",
"                   s = skip, o = output unchanged, p = process into PostScript.",
"             -dk = Fix for Denmark - code oslash and Oslash to 155 and 157.",
"             -dl = Delete input file(s) after print.    (Use with **CAUTION**)",
"          -dp[t] = Set DUPLEX printing mode with optional \"t\" = tumble.",
"      -dt<1|2|3> = Date format 1 (yyyy/mm/dd) or 2 (mm/dd/yy) or 3 (dd/mm/yy)",
"             -eh = Download extended PostScript [E]rror [H]andler to printer.",
"                   ***Warning - this may permanently alter the printer state***",
"        -en<i|e> = Encoding scheme. i=ISO-8859-1, e=PCPS Euro.    (Default=ISO)",
"      -es<b|i|c> = Enhanced print style for enhanced modes (see -mo2-6) where",
"                   b = bold (default), i = italic, c = combination bold italic.",
"       -fn<text> = Replace filename with \"text\" in banner.  See note (3).",
" -fo[code][size] = Code of font to use and/or font size.(Default = IBMPCFont10)",
"       -ga[text] = Gaudy banner with optional \"text\" comment. See note (3).",
"       -g1[text] = Gaudy banner page 1 only with optional \"text\". See note (3).",
"          -id[n] = IDentify originator with \"user@host\" in bottom corner.",
"                   Optional font size \"n\" >= 3        (Default font size = 4)",
"        -in[f|o] = Inverse - Last page first with optional mem sort disable",
"                   where f = new fast temp file and o = old temp file.",
"                   (Default is memory if enough free memory else \"f\")",
"          -lf<n> = Set line space to \"n%\" of the font size     (Default = 105%)",
"          -ll[n] = Set maximum line length to \"n\" chars.(Default = 65535 chars)",
"          -ln[n] = Show line numbers with \"n\" digits.      (Default = 4 digits)",
"          -lp<n> = Set lines per page to \"n\".           (Default = fit on page)",
"   -ma<l|r|t|b>n = Set designated margin to \"n\" points (1/72 inch)",
"                   where l = left, r = right, t = top and b = bottom.",
"          -mf[1] = Set manual paper feed.  Optional \"1\" = first page only.",
"          -mo<n> = Set Mode \"n\". 1 = Man Mode  2 = Mail  Mode  3 = C/C++ Mode",
"                                 4 = 4GL Mode  5 = Shell/Perl  6 = Pascal Mode",
"                                 7 = Fortran mode",
"             -nb = Omit page Banner.                      (Default = Banner ON)",
"             -nf = No Flush - DO NOT flush pages between files.",
"             -nz = No Zeros - Replace line number leading zeros with spaces.",
"   -of<filename> = Output filename. See note (1)."
#ifndef UNIX
"              (Default = LPT2)",
#else
,  /* to end -o line */
"    -P<printer>  = Name of printer to send job.       (Default = \'" DEFPRINT "\')",
#endif
"   -pp<filename> = User specified printer preparation file.",
"     -pr<#[-,$]> = Print specified page ranges where a range may be a single",
"                   page (#) or several contiguous pages (#-#).  Use \"$\" to",
"                   indicate end of file and commas to separate ranges.",
"             -pt = Include PostScript timing analysis code in output.",
"          -qu[t] = Quiet - summary only or Total quiet with optional \"t\"",
"             -ro = Rotate 90 Deg (Landscape)",
"          -2c[r] = Print text in 2 Columns with optional \"r\" = Landscape.",
" -sh[s<x>][l<y>] = Shade lines. Optional \"s\"hade factor (0 < x < 100) and",
"                   \"l\"ines to shade (0 < y < 5).    Defaults x = 96, y = 1",
"        -sm<o|e> = Swap margins on Odd or Even pages for double sided printing.",
"                   L/R margins will be swapped in Portrait, T/B in Landscape.",
"         -sz<xx> = Paper size. See note (2).                   (Default = A4)",
"          -tb[n] = Set tabstops to every n columns.     (Default = 8 columns)",
"             -tr = Truncate(Cut) long lines.                 (Default = Wrap)",
"    -ty<x>[,n,y] = Start with paper tray \"x\".  Optionally, switch to tray",
"                   \"y\" after \"n\" pages.  See note (2)",
"       -up<n>[l] = N-up pages (2 or 4). Optional \"l\" for divider lines.",
"       -wm<text> = Print \"text\" grey watermark in background. See note (3).",
"",
" NOTES:",
" (1)Should PCPS detect that its output is being piped to another program, it",
"    will automatically send the PostScript output to stdout and will ignore",
"    and all \"-of\" arguments except when \"-of-\" is used to cancel this feature.",
"",
" (2)To specify paper size or to select paper tray, use one of the following:",
"    Paper: \"a0\" - \"a4\"= A0 - A4, \"lt\"= US letter, \"lg\"= legal, \"ex\"= executive.",
"    Envelopes: \"co\"= COM10, \"mo\"= Monarch, and \"dl\"= DL.",
"    Alternatively, numbers (0-2) may be specified for paper tray selection.",
"",
" (3)Text attached to an argument (-fn, -ga, -g1 or -wm) may just follow the",
"    argument if one word (E.g. -gaHello), or the whole argument must be quoted",
"    (E.g. \"-fnOutput from yesterday\").  Also, if the character sequence \"##id\"",
"    is included anywhere in any of these texts, it will be replaced by the",
"    \"user@host\" identification as used in the \"-id\" argument.",
"",
" All arguments except \"-ls\" and \"-he\" can be overidden back to their defaults",
" by issuing the \"minus\" argument (Eg. -tr- or -dp- etc.)",
"",
" PCPS also supports two external files:",
"",
"*pcps.cfg - default argument file.  Arguments contained in pcps.cfg can be",
" overidden or reversed by command line arguments including the \"minus\"",
" arguments as mentioned above.  All arguments are read and processed",
" sequentially, first from pcps.cfg and then from the command line.",
"",
"*pcps.ppf - Printer Preparation File.  Whatever is contained in this file is",
" sent to the output file prior to the PostScript output of this program.",
"",
" Normally, both of these files are first sought in the directories specified",
" by the environment variables PCPSCFG and PCPSPPF.  If this is unsuccessful,",
" the current directory is checked, and finally the directory from where PCPS",
" originated.  The user can however, specify a different printer preparation",
" file with \"-pp<path>\" or disable this feature completely with \"-pp-\".",
"",
" EXAMPLES OF USAGE:",
"      pcps -2c -ro -ga -foc16 -inf -tb4 -mal72 -mar36 -ll90 -ofoutfile *.c",
"      pcps -2cr -id -dp -nb- -fo7.5 -tb- -ln *.asm *.doc hello.txt",
"      pcps -szlt -pr1-20,33,45-$ \"-gaA program to say hello\" -ln hello.c",
(char *)NULL
};
#endif /* PCPS_PCPS */
