/*
   Copyright (c) 2000 MicroSource

   This source file and all accompanying files are the exclusive property
   of the author Paul Carapetis and MicroSource, and no modifications are
   to be performed on said source without expressed permission from the
   author or an authorised representative of MicroSource, unless the
   purpose of such modifications is to effect a successful compile on your
   platform.

   This source is only to be distributed in its complete form and only with
   all of the following files included:

        INSTALL
        README
        ibmchars.uu
        license.doc
        newargs.txt
        pcps.man
        register.doc

        makefile
        define.h
        pcps.c
        pcps.h
        struct.h
        unix.c
        unix.h
        valargs.h

   The utility "PCPS" is a SHAREWARE product and you, as the user, agree
   that the source will be removed from your filesystem once the utility
   has been successfully compiled and is found to be functional.  Any
   changes to the source that were required for a successful compile must
   be returned to the author for inclusion in the main source control.

   The utility may be trialed for the period of time mentioned in the file
   license.doc, but must either be registered or destroyed within said
   trial time.  The cost and method of registration is detailed in the file
   license.doc.

Author:  Paul Carapetis  Internet: Paul_Carapetis@iname.com
Company: MicroSource     Snail:    10 Denise Court
                                   Narre Warren
                                   Australia  3805

*/
#ifndef PCPS_STRU
# define PCPS_STRU

typedef struct {
  char shortname[3];
  char name[15];
  char trayname[19];
  long height;
  long width;
  char scale[4];
} pstat;

typedef struct {        /* structure for paper size and default margins */
  char PaperName[15]; /* name of paper */
  long PaperH;        /* paper height */
  long PaperW;        /* paper width  */
  char     ScaleUp[4];/* scale for 2 or 4 up */
  unsigned Left;      /* Left  margin */
  unsigned Right;     /* Right margin */
  unsigned Top;       /* Top   margin */
  unsigned Bot;       /* Bot   margin */
  unsigned LeftPM;    /* default Left  margin for Portrait  */
  unsigned RightPM;   /* default Right margin for Portrait  */
  unsigned TopPM;     /* default Top   margin for Portrait  */
  unsigned BotPM;     /* default Bot   margin for Portrait  */
  unsigned LeftLM;    /* default Left  margin for Landscape */
  unsigned RightLM;   /* default Right margin for Landscape */
  unsigned TopLM;     /* default Top   margin for Landscape */
  unsigned BotLM;     /* default Bot   margin for Landscape */
} paper;

/*****************************************************************************/
/*    structure for dealing with files (myfindfirst etc)                     */
/*****************************************************************************/

/* common structure into which relevant information is copied */
typedef struct {
  char fname[MAX_PATH];
  unsigned fsecs;
  unsigned fmins;
  unsigned fhour;
  unsigned fday;
  unsigned fmonth;
  unsigned fyear;
  long fsize;
} file_dtl;

/*****************************************************************************/
/*     structure for linked list for page ranges                             */
/*****************************************************************************/

typedef struct pr {
  unsigned StartPage;
  unsigned EndPage;
#if defined (UNIX) || defined (MSVC32)
  struct pr *NextRange;
#else
  struct pr huge *NextRange;
#endif
} p_range;

/*****************************************************************************/
/*     strcuture for linked list to reverse pages                            */
/*****************************************************************************/

typedef struct pm {             /* for memory reverse */
#if defined (UNIX) || defined (MSVC32)
  char *pageptr;                /* pointer to page start in memory */
  struct pm *prevpageptr;       /* pointer to next page in linked list */
#else
  char huge *pageptr;           /* pointer to page start in memory */
  struct pm huge *prevpageptr;  /* pointer to next page in linked list */
#endif
} pptrm;

typedef struct pf {             /* for temp sort file reverse */
  unsigned long offset;         /* start of page offset from start of file */
#if defined (UNIX) || defined (MSVC32)
  struct pf *prevpageptr;       /* pointer to next page in linked list */
#else
  struct pf huge *prevpageptr;  /* pointer to next page in linked list */
#endif
} pptrf;

/*****************************************************************************/
/*                            Font Table                                     */
/*****************************************************************************/

typedef struct {        /* enhanced print index table */
  unsigned EBoldNum;     /* index to bold font */
  unsigned EItalNum;     /* index to italic font */
  unsigned EBItalNum;    /* index to bold italic font */
} enhfont;

typedef struct {        /* Structure for font list */
  char FontIndex[6];    /* index code of specified font */
  char FontName[29];    /* specified font name */
  unsigned  HeadFontNum;        /* [] index to font name for header */
  unsigned  EnhIndex[3];
} font;

typedef struct { /* table of start and end sequence for enhanced modes */
  char StartSeq[3];  /* start sequence */
  char EndSeq[3];    /* end sequence, if 0 the active to EOL */
} EnhChar;

#endif /* PCPS_STRU */
