/*
 
      This set of subroutines generates tektronix metacode.
 
*/
#include <stdio.h>
#include <math.h>
#define XFUDGE 0.
#define YFUDGE -0.1
static int n;
static float lx,ly;

pgmove(x,y)
float x, y;
{
  char xl,xh,yl,yh,gs,us;
  us = 31;
  gs = 29;
  n = n + 1;
  if (n > 15) {
    n = 0;
    fprintf(stdout,"%c\n%c",us,gs);
  }
  calc(x,y,&xl,&xh,&yl,&yh);
  fprintf(stdout,"%c%c%c%c%c",gs,yh,yl,xh,xl);
  lx = x;
  ly = y;
}

pgdraw(x,y,l)
float x, y;
int l;
{
  float linc,sinc,ddx,ddy;
  int color;
  ddx = x - lx;
  ddy = y - ly;
  color = 0;
  while (l < 1) {
    l += 4;
    color--;
  }
  while (l > 4) {
    l -= 4;
    color++;
  }
  if (l != 1) {
    if (l == 2) { /* long dashed */

      linc = 1.0 / 8.0;
      sinc = linc;
    } else
      if (l == 3) {/* dotted */
        linc = 3.0 / 160.0;
        sinc = 7.0 / 160.0;
      }
      else {
        /* short dashed */
        linc = 1.0 / 20.0;
        sinc = 15.0 / 160.0;
      }
    bklin(x,y,ddx,ddy,linc,sinc);
  }
  cont(x,y);
}

bklin(x,y,ddx,ddy,linc,sinc)
float x,y,ddx,ddy,linc,sinc;
{
  float i,j,k,l,il,is,jl,js,m,begin;
  if (ddx == 0.0) /* vertical line */
    if (y < ly) {
      begin = ly - linc;
      for (i = begin; (i - sinc) > y; i = i - (linc+sinc)){
        cont(x,i);
        pgmove(x,(i-sinc));
      }
    }
    else {
      begin = ly + linc;
      for (i = begin; (i+sinc) < y; i = i + (linc+sinc)) {
        cont(x,i);
        pgmove(x,(i+sinc));
      }
    }
  else
    if (ddy == 0.0) /* horizontal line */
      if (x < lx) {
        begin = lx -linc;
        for (i=begin; (i-sinc) > x; i=i-(linc+sinc)) {
          cont(i,y);
          pgmove((i-sinc),y);
        }
      }
      else {
        begin = lx + linc;
        for (i=begin; (i+sinc)<x; i=i+(linc+sinc)) {
          cont(i,y);
          pgmove((i+sinc),y);
        }
      }
    else { /* sloped line */
      /* is, js for space */
      m = ddy / ddx;
      is = fabs(m) * ddy /fabs(ddy) * sinc / hypot(m,1.0);
      js = is / m;
      /* il,jl for line */
      il = fabs(m) * ddy/fabs(ddy) * linc / hypot(m,1.0);
      jl = il /m;
      l = lx + jl;
      begin = ly + il;
      if ( ddy > 0)
        for (k = begin; (k+is)<y; k = k+(il+is)) {
          cont(l,k);
          pgmove(l+js,k+is);
          l = l + ( jl + js);
        }
      if ( ddy < 0)
        for (k = begin; (k+is)>y; k = k+(il+is)) {
          cont(l,k);
          pgmove(l+js,k+is);
          l = l+ (jl+js);
        }
    }
}

cont(x,y)
float x, y;
{
  char xl,xh,yl,yh,us,gs;
  us = 31;
  gs = 29;
  n = n + 1;
  if (n > 15) {
    n = 0;
    calc(lx,ly,&xl,&xh,&yl,&yh);
    fprintf(stdout,"%c\n%c%c%c%c%c",us,gs,yh,yl,xh,xl);
  }
  calc(x,y,&xl,&xh,&yl,&yh);
  fprintf(stdout,"%c%c%c%c",yh,yl,xh,xl);
  lx = x;
  ly = y;
}

pgtext(x,y,text)
float x, y;
char *text;
{
  char gs,us;
  gs = 29;
  us = 31;
  pgmove(x + XFUDGE,y + YFUDGE);
  fprintf(stdout,"%c%c%s\n%c",gs,us,text,gs);
}

pginit()
{
  char gs,us,esc,ff;
  gs = 29;
  us = 31;
  esc = 27;
  ff = 12;
  fprintf(stdout,"%c%c%c%c\r\n",gs,us,esc,ff);
  fprintf(stdout,"%c%c",gs,gs);
}

pgflsh()
{
  char dummy[82];
  char gs,us,esc,ff,ctlx;
  gets(dummy);
  gs = 29;
  us = 31;
  esc = 27;
  ff = 12;
  ctlx = 24;
  fprintf(stdout,"%c%c%c%c%c%c\r\n",gs,us,esc,ff,esc,ctlx);
}

pginfo(dcx,dcy)
float *dcx,*dcy;
{
  *dcx = 0.2;
  *dcy = 0.25;
}


calc(x,y,xlc,xhc,ylc,yhc)
/* subroutine calculates the ascii equi. for x and y */
float x, y;
char *xlc, *xhc, *ylc, *yhc;
{
  float xt, yt;
  int xl, yl, xh, yh;
  xt = x * 68.0;
  yt = y * 68.0;
  xh = xt / 32;
  xl = xt - xh * 32;
  xh = xh + 32;
  xl = xl + 64;
  yh = yt / 32;
  yl = yt - yh * 32;
  yh = yh + 32;
  yl = yl + 96;
  *xlc = xl;
  *ylc = yl;
  *xhc = xh;
  *yhc = yh;
}
