/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.ui.IconWrapperPanel;
import com.sshtools.common.ui.OptionsTab;
import com.sshtools.common.ui.PreferencesStore;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.SshToolsApplication;
import com.sshtools.common.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class GlobalOptionsTab
extends JPanel
implements OptionsTab {
    public static final String GLOBAL_ICON = "largeglobal.png";
    private JComboBox lafChooser;

    public GlobalOptionsTab() {
        Insets ins = new Insets(2, 2, 2, 2);
        JPanel s = new JPanel(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.weighty = 1.0;
        gbc1.insets = ins;
        gbc1.anchor = 18;
        gbc1.fill = 2;
        gbc1.weightx = 0.0;
        UIUtil.jGridBagAdd(s, new JLabel("Look and feel"), gbc1, -1);
        gbc1.weightx = 1.0;
        this.lafChooser = new JComboBox<UIManager.LookAndFeelInfo>(SshToolsApplication.getAllLookAndFeelInfo());
        UIUtil.jGridBagAdd(s, this.lafChooser, gbc1, 0);
        this.lafChooser.setRenderer(new LAFRenderer());
        IconWrapperPanel w = new IconWrapperPanel(new ResourceIcon(GlobalOptionsTab.class, GLOBAL_ICON), s);
        this.setLayout(new BorderLayout());
        this.add((Component)w, "Center");
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.reset();
    }

    public void reset() {
        String sel = PreferencesStore.get("apps.laf", UIManager.getLookAndFeel().getClass().getName());
        int i = 0;
        while (i < this.lafChooser.getModel().getSize()) {
            if (((UIManager.LookAndFeelInfo)this.lafChooser.getModel().getElementAt(i)).getClassName().equals(sel)) {
                this.lafChooser.setSelectedIndex(i);
                break;
            }
            ++i;
        }
    }

    public String getTabContext() {
        return "Options";
    }

    public Icon getTabIcon() {
        return null;
    }

    public String getTabTitle() {
        return "Global";
    }

    public String getTabToolTipText() {
        return "Global options.";
    }

    public int getTabMnemonic() {
        return 103;
    }

    public Component getTabComponent() {
        return this;
    }

    public boolean validateTab() {
        return true;
    }

    public void applyTab() {
        PreferencesStore.put("apps.laf", ((UIManager.LookAndFeelInfo)this.lafChooser.getSelectedItem()).getClassName());
    }

    public void tabSelected() {
    }

    class LAFRenderer
    extends DefaultListCellRenderer {
        LAFRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setText(((UIManager.LookAndFeelInfo)value).getName());
            return this;
        }
    }
}

