/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.session;

import com.sshtools.daemon.terminal.TerminalIO;
import com.sshtools.daemon.terminal.UserInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PseudoTerminalWrapper {
    private InputStream masterIn;
    private OutputStream masterOut;
    private InputStream slaveIn;
    private OutputStream slaveOut;
    private String term;
    private int cols;
    private int rows;
    private int width;
    private int height;
    private String modes;
    private TerminalIO terminal;
    private UserInput ui;

    public PseudoTerminalWrapper(String term, int cols, int rows, int width, int height, String modes) {
        this.term = term;
        this.cols = cols;
        this.rows = rows;
        this.height = height;
        this.width = width;
    }

    public void bindMasterInputStream(InputStream masterIn) {
        this.masterIn = masterIn;
    }

    public void bindMasterOutputStream(OutputStream masterOut) {
        this.masterOut = masterOut;
    }

    public void bindSlaveOutputStream(OutputStream slaveOut) {
        this.slaveOut = slaveOut;
    }

    public void bindSlaveInputStream(InputStream slaveIn) {
        this.slaveIn = slaveIn;
    }

    public void initialize() throws IOException {
        this.terminal = new TerminalIO(this.masterIn, this.masterOut, this.term, this.cols, this.rows);
        this.terminal.bindSlaveInputStream(this.slaveIn);
        this.terminal.bindSlaveOutputStream(this.slaveOut);
        this.ui = new UserInput(this.terminal, this.slaveOut);
    }

    public InputStream getMasterInputStream() {
        return this.terminal.getMasterInputStream();
    }
}

