/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DynamicClassLoader
extends ClassLoader {
    private static Log log = LogFactory.getLog(DynamicClassLoader.class);
    private static int generationCounter = 0;
    private Hashtable cache;
    private List classpath = new Vector();
    private int generation;
    private ClassLoader parent;

    public DynamicClassLoader(ClassLoader parent, List classpath) throws IllegalArgumentException {
        this.parent = parent;
        this.cache = new Hashtable();
        for (Object obj : classpath) {
            File f = null;
            if (obj instanceof String) {
                f = new File((String)obj);
            } else if (obj instanceof File) {
                f = (File)obj;
            } else {
                throw new IllegalArgumentException("Entries in classpath must be either a String or File object");
            }
            if (!f.exists()) {
                throw new IllegalArgumentException("Classpath " + f.getAbsolutePath() + " doesn't exist!");
            }
            if (!f.canRead()) {
                throw new IllegalArgumentException("Don't have read access for file " + f.getAbsolutePath());
            }
            if (!f.isDirectory() && !this.isJarArchive(f)) {
                throw new IllegalArgumentException(String.valueOf(f.getAbsolutePath()) + " is not a directory or jar file" + " or if it's a jar file then it is corrupted.");
            }
            this.classpath.add(f);
        }
        this.generation = generationCounter++;
    }

    public URL getResource(String name) {
        URL u = DynamicClassLoader.getSystemResource(name);
        if (u != null) {
            return u;
        }
        for (File file : this.classpath) {
            String fileName;
            File resFile;
            if (!file.isDirectory() || !(resFile = new File(file, fileName = name.replace('/', File.separatorChar))).exists()) continue;
            try {
                return new URL("file://" + resFile.getAbsolutePath());
            }
            catch (MalformedURLException badurl) {
                badurl.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public InputStream getResourceAsStream(String name) {
        InputStream s = DynamicClassLoader.getSystemResourceAsStream(name);
        if (s == null) {
            for (File file : this.classpath) {
                s = file.isDirectory() ? this.loadResourceFromDirectory(file, name) : this.loadResourceFromZipfile(file, name);
                if (s != null) break;
            }
        }
        return s;
    }

    public DynamicClassLoader reinstantiate() {
        return new DynamicClassLoader(this.parent, this.classpath);
    }

    public synchronized boolean shouldReload(String classname) {
        ClassCacheEntry entry = (ClassCacheEntry)this.cache.get(classname);
        if (entry == null) {
            return false;
        }
        if (entry.isSystemClass()) {
            return false;
        }
        boolean reload = entry.origin.lastModified() != entry.lastModified;
        return reload;
    }

    public synchronized boolean shouldReload() {
        Enumeration e = this.cache.elements();
        while (e.hasMoreElements()) {
            ClassCacheEntry entry = (ClassCacheEntry)e.nextElement();
            if (entry.isSystemClass()) continue;
            long msOrigin = entry.origin.lastModified();
            if (msOrigin == 0L) {
                return true;
            }
            if (msOrigin == entry.lastModified) continue;
            return true;
        }
        return false;
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = null;
        ClassCacheEntry entry = (ClassCacheEntry)this.cache.get(name);
        if (entry != null) {
            c = entry.loadedClass;
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
        if (!this.securityAllowsClass(name)) {
            return this.loadSystemClass(name, resolve);
        }
        try {
            c = this.loadSystemClass(name, resolve);
            if (c != null) {
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
        }
        catch (Exception e) {
            c = null;
        }
        Iterator it = this.classpath.iterator();
        ClassCacheEntry classCache = new ClassCacheEntry();
        while (it.hasNext()) {
            byte[] classData;
            File file = (File)it.next();
            try {
                classData = file.isDirectory() ? this.loadClassFromDirectory(file, name, classCache) : this.loadClassFromZipfile(file, name, classCache);
            }
            catch (IOException ioe) {
                classData = null;
            }
            if (classData == null) continue;
            classCache.loadedClass = c = this.defineClass(name, classData, 0, classData.length);
            classCache.lastModified = classCache.origin.lastModified();
            this.cache.put(name, classCache);
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
        throw new ClassNotFoundException(name);
    }

    private boolean isJarArchive(File file) {
        boolean isArchive = true;
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(file);
            }
            catch (ZipException zipCurrupted) {
                isArchive = false;
            }
            catch (IOException anyIOError) {
                isArchive = false;
            }
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return isArchive;
    }

    private byte[] loadBytesFromStream(InputStream in, int length) throws IOException {
        int nRead;
        byte[] buf = new byte[length];
        int count = 0;
        while (length > 0 && (nRead = in.read(buf, count, length)) != -1) {
            count += nRead;
            length -= nRead;
        }
        return buf;
    }

    private byte[] loadClassFromDirectory(File dir, String name, ClassCacheEntry cache) throws IOException {
        File classFile;
        String classFileName = String.valueOf(name.replace('.', File.separatorChar)) + ".class";
        if (!Character.isJavaIdentifierStart(classFileName.charAt(0))) {
            int start = 1;
            while (!Character.isJavaIdentifierStart(classFileName.charAt(start++))) {
            }
            classFileName = classFileName.substring(start);
        }
        if ((classFile = new File(dir, classFileName)).exists()) {
            cache.origin = classFile;
            FileInputStream in = new FileInputStream(classFile);
            try {
                byte[] byArray = this.loadBytesFromStream(in, (int)classFile.length());
                return byArray;
            }
            finally {
                ((InputStream)in).close();
            }
        }
        return null;
    }

    private byte[] loadClassFromZipfile(File file, String name, ClassCacheEntry cache) throws IOException {
        String classFileName = String.valueOf(name.replace('.', '/')) + ".class";
        ZipFile zipfile = new ZipFile(file);
        try {
            ZipEntry entry = zipfile.getEntry(classFileName);
            if (entry != null) {
                cache.origin = file;
                byte[] byArray = this.loadBytesFromStream(zipfile.getInputStream(entry), (int)entry.getSize());
                return byArray;
            }
            return null;
        }
        finally {
            zipfile.close();
        }
    }

    private InputStream loadResourceFromDirectory(File dir, String name) {
        String fileName = name.replace('/', File.separatorChar);
        File resFile = new File(dir, fileName);
        if (resFile.exists()) {
            try {
                return new FileInputStream(resFile);
            }
            catch (FileNotFoundException shouldnothappen) {
                return null;
            }
        }
        return null;
    }

    private InputStream loadResourceFromZipfile(File file, String name) {
        try {
            ZipFile zipfile = new ZipFile(file);
            ZipEntry entry = zipfile.getEntry(name);
            if (entry != null) {
                return zipfile.getInputStream(entry);
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private Class loadSystemClass(String name, boolean resolve) throws NoClassDefFoundError, ClassNotFoundException {
        Class<?> c = this.parent.loadClass(name);
        if (resolve) {
            this.resolveClass(c);
        }
        ClassCacheEntry cacheEntry = new ClassCacheEntry();
        cacheEntry.origin = null;
        cacheEntry.loadedClass = c;
        cacheEntry.lastModified = Long.MAX_VALUE;
        this.cache.put(name, cacheEntry);
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    private boolean securityAllowsClass(String className) {
        SecurityManager security;
        block3: {
            try {
                security = System.getSecurityManager();
                if (security != null) break block3;
                return true;
            }
            catch (SecurityException e) {
                return false;
            }
        }
        int lastDot = className.lastIndexOf(46);
        security.checkPackageDefinition(lastDot > -1 ? className.substring(0, lastDot) : "");
        return true;
    }

    private static class ClassCacheEntry {
        Class loadedClass;
        File origin;
        long lastModified;

        private ClassCacheEntry() {
        }

        public boolean isSystemClass() {
            return this.origin == null;
        }
    }
}

