/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gCLINE.data;

import edu.harvard.mgh.purcell.gCLINE.StartFrame;
import edu.harvard.mgh.purcell.gCLINE.data.OperationInfo;
import edu.harvard.mgh.purcell.gCLINE.data.Record;
import edu.harvard.mgh.purcell.gCLINE.general.ErrorManager;
import edu.harvard.mgh.purcell.gCLINE.pane.FolderView;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.log4j.Logger;

public class AutoUpdater
extends Timer {
    private Logger logger = Logger.getLogger(AutoUpdater.class);
    private StartFrame frame;
    private String op_status_ext;
    public static String COMPLETE = "Complete";
    public static String RUNNING = "Running";
    public static String ERROR = "Failed";
    private HashMap<String, String> opStatis;
    private Record data;
    private ErrorManager errors;
    private TimerTask readLogs = new TimerTask(){

        public void run() {
            AutoUpdater.this.logger.info("[readLogs] Entering...");
            if (AutoUpdater.this.opStatis == null) {
                AutoUpdater.this.errors.createError("opStatis is null. Canceling the auto-updating", "run@TimerTask@AutoUpdater.java");
                AutoUpdater.this.cancel();
                return;
            }
            Vector<String> allfiles = AutoUpdater.this.data.getHomeFiles();
            AutoUpdater.this.logger.info("[run()@readLogs] all the files are: " + allfiles.toString());
            if (AutoUpdater.this.data.isRemote()) {
                int numFiles = allfiles.size();
                Vector<String> temp = new Vector<String>();
                int i = 0;
                while (i < numFiles) {
                    String file = allfiles.get(i);
                    if ((file.endsWith(AutoUpdater.this.data.getLogExt()) && !file.equals(AutoUpdater.this.data.getLogExt()) || file.endsWith(AutoUpdater.this.op_status_ext) && !file.equals(AutoUpdater.this.op_status_ext)) && !new File(AutoUpdater.this.data.getLocalFolder(), file).exists()) {
                        temp.add(String.valueOf(AutoUpdater.this.data.getRemoteFolder()) + file);
                        AutoUpdater.this.logger.info("[run()@readLogs] [" + file + "] added to download queue.");
                    }
                    ++i;
                }
                String[] filesToGet = new String[temp.size()];
                int i2 = 0;
                while (i2 < filesToGet.length) {
                    filesToGet[i2] = (String)temp.get(i2);
                    ++i2;
                }
                StartFrame startFrame = AutoUpdater.this.frame;
                startFrame.getClass();
                new StartFrame.Download(startFrame, AutoUpdater.this.data, false, AutoUpdater.this.data.getLocalFolder(), filesToGet).run();
            }
            for (OperationInfo op : AutoUpdater.this.data.getAllOp()) {
                String s = op.getName();
                if (s != null && AutoUpdater.this.opStatis.get(s) == null) {
                    AutoUpdater.this.logger.info("[run()@readLogs] [" + s + "] is being flagged as Running");
                    AutoUpdater.this.opStatis.put(s, RUNNING);
                }
                if (s != null && ((String)AutoUpdater.this.opStatis.get(s)).equals(RUNNING)) {
                    AutoUpdater.this.logger.info("[run()@readLogs] [" + s + "] was running.");
                    File gplinkLog = new File(AutoUpdater.this.data.getLocalFolder(), String.valueOf(s) + AutoUpdater.this.op_status_ext);
                    if (gplinkLog.exists()) {
                        String setting = "1";
                        try {
                            BufferedReader in = new BufferedReader(new FileReader(gplinkLog));
                            setting = in.readLine();
                            in.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        for (String file : allfiles) {
                            if (!file.startsWith(String.valueOf(s) + ".") || file.endsWith(AutoUpdater.this.op_status_ext)) continue;
                            op.addFile("output", file, "", "");
                        }
                        if (setting != null && setting.equals("0")) {
                            AutoUpdater.this.opStatis.put(s, COMPLETE);
                        } else {
                            AutoUpdater.this.opStatis.put(s, ERROR);
                        }
                        AutoUpdater.this.data.nodeStructureChanged(AutoUpdater.this.data.getOp(s));
                        continue;
                    }
                    AutoUpdater.this.opStatis.put(s, RUNNING);
                    AutoUpdater.this.logger.info("[run()@readLogs] [" + s + "] is still running.");
                    continue;
                }
                AutoUpdater.this.logger.info("[run()@readLogs] [" + s + "] is not flagged as running no files added.");
            }
            if (AutoUpdater.this.frame != null && ((AutoUpdater)AutoUpdater.this).frame.folderViewer != null) {
                FolderView folderView = ((AutoUpdater)AutoUpdater.this).frame.folderViewer;
                folderView.getClass();
                EventQueue.invokeLater(new FolderView.UpdateJList(folderView, false));
            }
            AutoUpdater.this.data.saveInfo();
            AutoUpdater.this.logger.info("[readLogs] ...Ending");
        }
    };

    public void cancel() {
        super.cancel();
        this.opStatis = null;
        this.logger.info("[cancel()]");
    }

    public void addOp(String opName) {
        this.opStatis.put(opName, RUNNING);
    }

    public AutoUpdater(StartFrame f, Record d, String givenExt, ErrorManager e, int sec) {
        this.logger.info("(AutoUpdater(Record, String, ErrorManager))Intailizing the update");
        this.op_status_ext = givenExt;
        this.frame = f;
        this.data = d;
        this.errors = e;
        this.opStatis = new HashMap();
        for (OperationInfo ops : this.data.getAllOp()) {
            this.opStatis.put(ops.getName(), RUNNING);
        }
        this.readLogs.run();
        long interval = sec * 1000;
        this.schedule(this.readLogs, 0L, interval);
    }

    private String processOpName(String s) {
        if ((s = s.split(":")[0]).contains("<html>")) {
            s = s.substring(new String("<html>").length(), s.length());
        }
        return s;
    }

    public class MyRenderer
    extends DefaultTreeCellRenderer {
        Icon sucessIcon;
        Icon failIcon;
        Icon runningIcon;
        Icon fileInfoIcon;

        public MyRenderer(Icon sicon, Icon ficon, Icon ricon, Icon fileIcon) {
            this.sucessIcon = sicon;
            this.failIcon = ficon;
            this.runningIcon = ricon;
            this.fileInfoIcon = fileIcon;
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            AutoUpdater.this.logger.info("[getTreeCellRendererComponent():MyRenderer] looking at" + value.toString() + ":" + (String)AutoUpdater.this.opStatis.get(AutoUpdater.this.processOpName(value.toString())));
            if (this.isRunningOp(value)) {
                this.setIcon(this.runningIcon);
            } else if (this.isCompleteOp(value)) {
                this.setIcon(this.sucessIcon);
            } else if (this.isFailedOp(value)) {
                this.setIcon(this.failIcon);
            } else if (!leaf && this.isFile(value)) {
                this.setIcon(this.fileInfoIcon);
            }
            return this;
        }

        private boolean isFile(Object value) {
            return value != null && !value.toString().equals("Input files") && !value.toString().equals("Output files");
        }

        private boolean isRunningOp(Object value) {
            return AutoUpdater.this.opStatis != null && AutoUpdater.this.opStatis.get(AutoUpdater.this.processOpName(value.toString())) != null && ((String)AutoUpdater.this.opStatis.get(AutoUpdater.this.processOpName(value.toString()))).equals(RUNNING);
        }

        protected boolean isCompleteOp(Object value) {
            return AutoUpdater.this.opStatis != null && AutoUpdater.this.opStatis.get(AutoUpdater.this.processOpName(value.toString())) != null && ((String)AutoUpdater.this.opStatis.get(AutoUpdater.this.processOpName(value.toString()))).equals(COMPLETE);
        }

        protected boolean isFailedOp(Object value) {
            return AutoUpdater.this.opStatis != null && AutoUpdater.this.opStatis.get(AutoUpdater.this.processOpName(value.toString())) != null && ((String)AutoUpdater.this.opStatis.get(AutoUpdater.this.processOpName(value.toString()))).equals(ERROR);
        }
    }
}

