/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gPLINK2.forms;

import edu.harvard.mgh.purcell.gCLINE.data.FileInfo;
import edu.harvard.mgh.purcell.gPLINK2.GPLINK;
import edu.harvard.mgh.purcell.gPLINK2.baseForm.Form;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class Regression
extends Form {
    public static String name = "Linear/logistic regression";
    private JRadioButton freqButton;
    private JRadioButton genoButton;
    private JCheckBox covarButton;
    private JTextField covarField;
    Form.BrowseButton pickCovar;

    public Regression(GPLINK mf) {
        super(mf, name);
        this.validBody = true;
        this.pack();
        this.setVisible(true);
    }

    protected JPanel createBody() {
        JPanel body = new JPanel();
        this.covarField = new JTextField(10);
        this.covarField.getDocument().addDocumentListener(this.validateBodyDL);
        this.pickCovar = new Form.BrowseButton(this.covarField, ".cov", "Covariate File");
        this.pickCovar.setEnabled(false);
        this.freqButton = new JRadioButton("Linear/logistic regression (--linear)");
        this.freqButton.addActionListener(this.validateBodyAL);
        this.freqButton.setSelected(true);
        this.genoButton = new JRadioButton("2df genotypic model (--linear --genotypic)");
        this.genoButton.addActionListener(this.validateBodyAL);
        this.covarButton = new JCheckBox("Covariate file (--covar)");
        this.covarButton.addActionListener(this.validateBodyAL);
        Regression.bundel((JToggleButton)this.covarButton, this.covarField, this.pickCovar);
        ButtonGroup pickOne = new ButtonGroup();
        pickOne.add(this.freqButton);
        pickOne.add(this.genoButton);
        body.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        body.add((Component)this.freqButton, c);
        c.gridy = 1;
        body.add((Component)this.genoButton, c);
        c.gridy = 2;
        body.add((Component)this.covarButton, c);
        c.weightx = 1.0;
        c.gridx = 1;
        body.add((Component)this.covarField, c);
        c.weightx = 0.0;
        c.gridx = 2;
        body.add((Component)this.pickCovar, c);
        return body;
    }

    protected void isBodyValid() {
        this.validBody = !this.covarButton.isSelected() || this.covarField.getText().length() != 0;
        this.okForm();
    }

    protected String processBody() {
        String ans = "--linear";
        if (this.genoButton.isSelected()) {
            ans = String.valueOf(ans) + " --genotypic";
        }
        if (this.covarButton.isSelected()) {
            ans = String.valueOf(ans) + " --covar " + FileInfo.quote(this.covarField.getText());
        }
        return ans;
    }
}

