//
// SocketDefs.h
//
// $Id: //poco/1.4/Net/include/Poco/Net/SocketDefs.h#3 $
//
// Library: Net
// Package: NetCore
// Module:  SocketDefs
//
// Include platform-specific header files for sockets.
//
// Copyright (c) 2005-2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef Net_SocketDefs_INCLUDED
#define Net_SocketDefs_INCLUDED


#if defined(POCO_OS_FAMILY_WINDOWS)
#include "Poco/UnWindows.h"
#include <winsock2.h>
#include <ws2tcpip.h>
#define POCO_INVALID_SOCKET  INVALID_SOCKET
#define poco_socket_t        SOCKET
#define poco_socklen_t       int
#define poco_ioctl_request_t int
#define poco_closesocket(s)  closesocket(s)
#define POCO_EINTR           WSAEINTR
#define POCO_EACCES          WSAEACCES
#define POCO_EFAULT          WSAEFAULT
#define POCO_EINVAL          WSAEINVAL
#define POCO_EMFILE          WSAEMFILE
#define POCO_EAGAIN          WSAEWOULDBLOCK
#define POCO_EWOULDBLOCK     WSAEWOULDBLOCK
#define POCO_EINPROGRESS     WSAEINPROGRESS
#define POCO_EALREADY        WSAEALREADY
#define POCO_ENOTSOCK        WSAENOTSOCK
#define POCO_EDESTADDRREQ    WSAEDESTADDRREQ
#define POCO_EMSGSIZE        WSAEMSGSIZE
#define POCO_EPROTOTYPE      WSAEPROTOTYPE
#define POCO_ENOPROTOOPT     WSAENOPROTOOPT
#define POCO_EPROTONOSUPPORT WSAEPROTONOSUPPORT
#define POCO_ESOCKTNOSUPPORT WSAESOCKTNOSUPPORT
#define POCO_ENOTSUP         WSAEOPNOTSUPP
#define POCO_EPFNOSUPPORT    WSAEPFNOSUPPORT
#define POCO_EAFNOSUPPORT    WSAEAFNOSUPPORT
#define POCO_EADDRINUSE      WSAEADDRINUSE
#define POCO_EADDRNOTAVAIL   WSAEADDRNOTAVAIL
#define POCO_ENETDOWN        WSAENETDOWN
#define POCO_ENETUNREACH     WSAENETUNREACH
#define POCO_ENETRESET       WSAENETRESET
#define POCO_ECONNABORTED    WSAECONNABORTED
#define POCO_ECONNRESET      WSAECONNRESET
#define POCO_ENOBUFS         WSAENOBUFS
#define POCO_EISCONN         WSAEISCONN
#define POCO_ENOTCONN        WSAENOTCONN
#define POCO_ESHUTDOWN       WSAESHUTDOWN
#define POCO_ETIMEDOUT       WSAETIMEDOUT
#define POCO_ECONNREFUSED    WSAECONNREFUSED
#define POCO_EHOSTDOWN       WSAEHOSTDOWN
#define POCO_EHOSTUNREACH    WSAEHOSTUNREACH
#define POCO_ESYSNOTREADY    WSASYSNOTREADY
#define POCO_ENOTINIT        WSANOTINITIALISED
#define POCO_HOST_NOT_FOUND  WSAHOST_NOT_FOUND
#define POCO_TRY_AGAIN       WSATRY_AGAIN
#define POCO_NO_RECOVERY     WSANO_RECOVERY
#define POCO_NO_DATA         WSANO_DATA
#elif defined(POCO_VXWORKS)
#include <hostLib.h>
#include <ifLib.h>
#include <inetLib.h>
#include <ioLib.h>
#include <resolvLib.h>
#include <types.h>
#include <socket.h>
#include <netinet/tcp.h>
#define POCO_INVALID_SOCKET  -1
#define poco_socket_t        int
#define poco_socklen_t       int
#define poco_ioctl_request_t int
#define poco_closesocket(s)  ::close(s)
#define POCO_EINTR           EINTR
#define POCO_EACCES          EACCES
#define POCO_EFAULT          EFAULT
#define POCO_EINVAL          EINVAL
#define POCO_EMFILE          EMFILE
#define POCO_EAGAIN          EAGAIN
#define POCO_EWOULDBLOCK     EWOULDBLOCK
#define POCO_EINPROGRESS     EINPROGRESS
#define POCO_EALREADY        EALREADY
#define POCO_ENOTSOCK        ENOTSOCK
#define POCO_EDESTADDRREQ    EDESTADDRREQ
#define POCO_EMSGSIZE        EMSGSIZE
#define POCO_EPROTOTYPE      EPROTOTYPE
#define POCO_ENOPROTOOPT     ENOPROTOOPT
#define POCO_EPROTONOSUPPORT EPROTONOSUPPORT
#define POCO_ESOCKTNOSUPPORT ESOCKTNOSUPPORT
#define POCO_ENOTSUP         ENOTSUP
#define POCO_EPFNOSUPPORT    EPFNOSUPPORT
#define POCO_EAFNOSUPPORT    EAFNOSUPPORT
#define POCO_EADDRINUSE      EADDRINUSE
#define POCO_EADDRNOTAVAIL   EADDRNOTAVAIL
#define POCO_ENETDOWN        ENETDOWN
#define POCO_ENETUNREACH     ENETUNREACH
#define POCO_ENETRESET       ENETRESET
#define POCO_ECONNABORTED    ECONNABORTED
#define POCO_ECONNRESET      ECONNRESET
#define POCO_ENOBUFS         ENOBUFS
#define POCO_EISCONN         EISCONN
#define POCO_ENOTCONN        ENOTCONN
#define POCO_ESHUTDOWN       ESHUTDOWN
#define POCO_ETIMEDOUT       ETIMEDOUT
#define POCO_ECONNREFUSED    ECONNREFUSED
#define POCO_EHOSTDOWN       EHOSTDOWN
#define POCO_EHOSTUNREACH    EHOSTUNREACH
#define POCO_ESYSNOTREADY    -4
#define POCO_ENOTINIT        -5
#define POCO_HOST_NOT_FOUND  HOST_NOT_FOUND
#define POCO_TRY_AGAIN       TRY_AGAIN
#define POCO_NO_RECOVERY     NO_RECOVERY
#define POCO_NO_DATA         NO_DATA
#elif defined(POCO_OS_FAMILY_UNIX) || defined(POCO_OS_FAMILY_VMS)
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#if POCO_OS != POCO_OS_HPUX
#include <sys/select.h>
#endif
#include <sys/ioctl.h>
#if defined(POCO_OS_FAMILY_VMS)
#include <inet.h>
#else
#include <arpa/inet.h>
#endif
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <netdb.h>
#if defined(POCO_OS_FAMILY_UNIX)
#include <net/if.h>
#endif
#if defined(sun) || defined(__APPLE__)
#include <sys/sockio.h>
#include <sys/filio.h>
#endif
#define POCO_INVALID_SOCKET  -1
#define poco_socket_t        int
#define poco_socklen_t       socklen_t
#if defined(POCO_OS_FAMILY_BSD)
#define poco_ioctl_request_t unsigned long
#else
#define poco_ioctl_request_t int
#endif
#define poco_closesocket(s)  ::close(s)
#define POCO_EINTR           EINTR
#define POCO_EACCES          EACCES
#define POCO_EFAULT          EFAULT
#define POCO_EINVAL          EINVAL
#define POCO_EMFILE          EMFILE
#define POCO_EAGAIN          EAGAIN
#define POCO_EWOULDBLOCK     EWOULDBLOCK
#define POCO_EINPROGRESS     EINPROGRESS
#define POCO_EALREADY        EALREADY
#define POCO_ENOTSOCK        ENOTSOCK
#define POCO_EDESTADDRREQ    EDESTADDRREQ
#define POCO_EMSGSIZE        EMSGSIZE
#define POCO_EPROTOTYPE      EPROTOTYPE
#define POCO_ENOPROTOOPT     ENOPROTOOPT
#define POCO_EPROTONOSUPPORT EPROTONOSUPPORT
#if defined(ESOCKTNOSUPPORT)
#define POCO_ESOCKTNOSUPPORT ESOCKTNOSUPPORT
#else
#define POCO_ESOCKTNOSUPPORT -1
#endif
#define POCO_ENOTSUP         ENOTSUP
#define POCO_EPFNOSUPPORT    EPFNOSUPPORT
#define POCO_EAFNOSUPPORT    EAFNOSUPPORT
#define POCO_EADDRINUSE      EADDRINUSE
#define POCO_EADDRNOTAVAIL   EADDRNOTAVAIL
#define POCO_ENETDOWN        ENETDOWN
#define POCO_ENETUNREACH     ENETUNREACH
#define POCO_ENETRESET       ENETRESET
#define POCO_ECONNABORTED    ECONNABORTED
#define POCO_ECONNRESET      ECONNRESET
#define POCO_ENOBUFS         ENOBUFS
#define POCO_EISCONN         EISCONN
#define POCO_ENOTCONN        ENOTCONN
#if defined(ESHUTDOWN)
#define POCO_ESHUTDOWN       ESHUTDOWN
#else
#define POCO_ESHUTDOWN       -2
#endif
#define POCO_ETIMEDOUT       ETIMEDOUT
#define POCO_ECONNREFUSED    ECONNREFUSED
#if defined(EHOSTDOWN)
#define POCO_EHOSTDOWN       EHOSTDOWN
#else
#define POCO_EHOSTDOWN       -3
#endif
#define POCO_EHOSTUNREACH    EHOSTUNREACH
#define POCO_ESYSNOTREADY    -4
#define POCO_ENOTINIT        -5
#define POCO_HOST_NOT_FOUND  HOST_NOT_FOUND
#define POCO_TRY_AGAIN       TRY_AGAIN
#define POCO_NO_RECOVERY     NO_RECOVERY
#define POCO_NO_DATA         NO_DATA
#endif


#if defined(POCO_OS_FAMILY_BSD) || (POCO_OS == POCO_OS_TRU64) || (POCO_OS == POCO_OS_AIX) || (POCO_OS == POCO_OS_IRIX) || (POCO_OS == POCO_OS_QNX) || (POCO_OS == POCO_OS_VXWORKS)
#define POCO_HAVE_SALEN      1
#endif


#if (POCO_OS == POCO_OS_HPUX) || (POCO_OS == POCO_OS_SOLARIS) || (POCO_OS == POCO_OS_WINDOWS_CE)
#define POCO_BROKEN_TIMEOUTS 1
#endif


#if defined(POCO_HAVE_SALEN)
#define poco_set_sa_len(pSA, len) (pSA)->sa_len   = (len)
#define poco_set_sin_len(pSA)     (pSA)->sin_len  = sizeof(struct sockaddr_in)
#if defined(POCO_HAVE_IPv6)
#define poco_set_sin6_len(pSA)    (pSA)->sin6_len = sizeof(struct sockaddr_in6)
#endif
#else
#define poco_set_sa_len(pSA, len) (void) 0
#define poco_set_sin_len(pSA)     (void) 0
#define poco_set_sin6_len(pSA)    (void) 0
#endif


#ifndef INADDR_NONE
#define INADDR_NONE 0xFFFFFFFF
#endif


#endif // Net_SocketDefs_INCLUDED
