/*
 * Handle errors while parsing the configuration file.
 * Copyright (C) 1999  Steven Brown
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Steven Brown <swbrown@ucsd.edu>
 *
 * $Id: conf-error.c,v 1.2 1999/05/19 08:22:15 kefka Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include "conf-error.h"

/* Name of the program. */
extern char *progname;

/* Name of the conf file. */
extern char *conf_name;

/* Line number flex is parsing. */
extern int yylineno;

/* Number of errors encountered. */
extern int yynerrs;


/* Error handler for bison/yacc errors. */
int yyerror(char *message, ...) {
	va_list ap;
	va_start(ap, message);
	
	/* Print the error message. */
	fprintf(stderr,"%s: %s:%i: ",progname, conf_name, yylineno);
	vfprintf(stderr,message,ap);
	fprintf(stderr,"\n");
	
	/* We have an error. */
	yynerrs++;
	
	va_end(ap);
	return(1);
}
