/*
 * Handle incoming events from the power line or from the client.
 * Copyright (C) 1999  Steven Brown
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Steven Brown <swbrown@ucsd.edu>
 *
 * $Id: event.c,v 1.2 1999/05/19 08:22:16 kefka Exp $
 */

#include <config.h>
#include <unistd.h>
#include <stdlib.h>
#include "event.h"
#include "stacklist.h"
#include "conf-proto.h"
#include "conf.h"
#include "conf-parse.h"
#include "error.h"


/* For the daemon to take action on a received event. */
void event_action(Event *event) {
	Stacklist_Entry *stacklist_entry;
	Macro *macro;
	State *state;
	int i,j,k;
	
	/* Loop for each device in the event. */
	for(j=0; j < event->devices; j++) {
		
		/* *** Set the new status for each device. */
		
		/* Search for a macro that listens for this event. */
		for(stacklist_entry=conf_macrolist.first; stacklist_entry != NULL; stacklist_entry=stacklist_entry->previous) {
			macro=(Macro *) stacklist_entry->info;
			
			/* Check the statetable in the macro to see if we match it. */
			for(i=0; i < macro->statetable->entries; i++) {
				state=&((State *) macro->statetable->data)[i];
				
				/* The functions must match. */
				if(state->function.command != event->command) continue;
				
				/* *** What about dim/bright and extended? */
				
				/* It must contain our device. */
				for(k=0; k < state->devices; k++) {
					
					/* The housecode and devicecode must match. */
					if((state->device[k]->housecode == event->housecode) && (state->device[k]->devicecode == event->device[j])) {
						
						/* Activate this macro. */
						event_macrocall(macro);
					}
				}
			}
		}
	}

	return;
}


/* For the daemon to call a macro. */
void event_macrocall(Macro *macro) {
	debug(DEBUG_STATUS, "Doing a macrocall on macro name '%s'.", macro->name);
	
	/* *** Notify all monitoring clients about running this macro. */
	
	/* Execute all the commands in the macro. */
	event_execute_commands(&macro->macro_commands);
	
	return;
}


/* Run a group of macro commands. */
void event_execute_commands(Macro_Commands *macro_commands) {
	int i;
	
	/* Loop through each command running it. */
	for(i=0; i < macro_commands->commands; i++) {
		
		/* Is this a run command? */
		if(macro_commands->macro_command[i].type == MACRO_COMMAND_RUN) {
			
			/* Fork to run the command in the child process. */
			if(fork() == 0) {
				system(macro_commands->macro_command[i].info.command_run.commandline);
				exit(0);
			}
		}
		
		/* Is this a 'command' command? */
		else if(macro_commands->macro_command[i].type == MACRO_COMMAND_COMMAND) {
			
		}
		
		/* It is an if command? */
		else if(macro_commands->macro_command[i].type == MACRO_COMMAND_IF) {
			
		}
		
		/* If it isn't any of them, that's really bad. */
		else panic("Unknown macro command type %i.", macro_commands->macro_command[i].type);
	}
	
	return;
}
