/*
 * Code to handle dealing with client monitor connections.
 * Copyright (C) 1999  Steven Brown
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Steven Brown <swbrown@ucsd.edu>
 *
 * $Id: monitor.c,v 1.3 1999/05/19 08:22:16 kefka Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "ppowerd.h"
#include "ppowerd-proto.h"
#include "monitor.h"
#include "error.h"


/* Broadcasts data to all listening monitors. */
void monitor_broadcast(void *data, int size) {
	int i;
	
	/* *** Why do we do this loop backwards? */
	
	/* Send it to each listener. */
	for(i=user_monitor_sockets; i > 0; i--) {
		
		/* Write it to this one. */
		if(write(pollfd[POLL_USER_MONITOR + (i - 1)].fd, data, size) != size) {
			debug(DEBUG_UNEXPECTED, "Client monitor connection failed to keep up, dropping it.");
			
			/* It couldn't keep up with us, so kill it. */
			/* *** */
			fatal("Monitor couldn't keep up.");
		}
	}

	return;	
}
